/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatArithmeticException;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.AprationalMath;
import org.apfloat.BernoulliHelper;
import org.apfloat.BesselHelper;
import org.apfloat.HurwitzZetaHelper;
import org.apfloat.HypergeometricHelper;
import org.apfloat.IncompleteGammaHelper;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.LambertWHelper;
import org.apfloat.LossOfPrecisionException;
import org.apfloat.OverflowException;
import org.apfloat.ParallelHelper;
import org.apfloat.RoundingHelper;
import org.apfloat.ZetaHelper;
import org.apfloat.spi.Util;

public class ApcomplexMath {
    private ApcomplexMath() {
    }

    @Deprecated
    public static Apcomplex negate(Apcomplex z) throws ApfloatRuntimeException {
        return z.negate();
    }

    public static Apfloat abs(Apcomplex z) throws ApfloatRuntimeException {
        if (z.real().signum() == 0) {
            return ApfloatMath.abs(z.imag());
        }
        if (z.imag().signum() == 0) {
            return ApfloatMath.abs(z.real());
        }
        return ApfloatMath.sqrt(ApcomplexMath.norm(z));
    }

    public static Apfloat norm(Apcomplex z) throws ApfloatRuntimeException {
        return ApfloatMath.multiplyAdd(z.real(), z.real(), z.imag(), z.imag());
    }

    public static Apfloat arg(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.atan2(z.imag(), z.real());
    }

    public static Apcomplex scale(Apcomplex z, long scale) throws ApfloatRuntimeException {
        return new Apcomplex(ApfloatMath.scale(z.real(), scale), ApfloatMath.scale(z.imag(), scale));
    }

    public static Apcomplex pow(Apcomplex z, long n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0L) {
            if (z.isZero()) {
                throw new ApfloatArithmeticException("Zero to power zero", "pow.zeroToZero", new Object[0]);
            }
            return new Apcomplex(new Apfloat(1L, Long.MAX_VALUE, z.radix()));
        }
        if (n < 0L) {
            z = Apcomplex.ONES[z.radix()].divide(z);
            n = -n;
        }
        return ApcomplexMath.powAbs(z, n);
    }

    private static Apcomplex powAbs(Apcomplex z, long n) throws ArithmeticException, ApfloatRuntimeException {
        long precision = z.precision();
        z = ApfloatHelper.extendPrecision(z);
        int b2pow = 0;
        while ((n & 1L) == 0L) {
            ++b2pow;
            n >>>= 1;
        }
        Apcomplex r = z;
        while ((n >>>= 1) > 0L) {
            z = z.multiply(z);
            if ((n & 1L) == 0L) continue;
            r = r.multiply(z);
        }
        while (b2pow-- > 0) {
            r = r.multiply(r);
        }
        return ApfloatHelper.setPrecision(r, precision);
    }

    public static Apcomplex sqrt(Apcomplex z) throws ApfloatRuntimeException {
        return ApcomplexMath.root(z, 2L);
    }

    public static Apcomplex cbrt(Apcomplex z) throws ApfloatRuntimeException {
        return ApcomplexMath.root(z, 3L);
    }

    public static Apcomplex root(Apcomplex z, long n) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.root(z, n, 0L);
    }

    public static Apcomplex root(Apcomplex z, long n, long k) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0L) {
            throw new ApfloatArithmeticException("Zeroth root", "root.zeroth", new Object[0]);
        }
        if (z.isZero()) {
            if (n < 0L) {
                throw new ApfloatArithmeticException("Inverse root of zero", "inverseRoot.ofZero", new Object[0]);
            }
            return Apcomplex.ZEROS[z.radix()];
        }
        if (n == 1L) {
            return z;
        }
        if (z.imag().signum() == 0 && z.real().signum() > 0 && (k %= n) == 0L) {
            return new Apcomplex(ApfloatMath.root(z.real(), n));
        }
        if (n < 0L) {
            return ApcomplexMath.inverseRootAbs(z, -n, k);
        }
        if (n == 2L) {
            return z.multiply(ApcomplexMath.inverseRootAbs(z, 2L, k));
        }
        if (n == 3L) {
            if (z.real().signum() < 0) {
                k = z.imag().signum() == 0 ? 1L - k : k - 1L;
                k %= n;
            } else {
                k = -k;
            }
            Apcomplex w = z.multiply(z);
            return z.multiply(ApcomplexMath.inverseRootAbs(w, 3L, k));
        }
        return ApcomplexMath.inverseRootAbs(ApcomplexMath.inverseRootAbs(z, n, k), 1L, 0L);
    }

    public static Apcomplex inverseRoot(Apcomplex z, long n) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.inverseRoot(z, n, 0L);
    }

    public static Apcomplex inverseRoot(Apcomplex z, long n, long k) throws ArithmeticException, ApfloatRuntimeException {
        if (z.isZero()) {
            throw new ApfloatArithmeticException("Inverse root of zero", "inverseRoot.ofZero", new Object[0]);
        }
        if (n == 0L) {
            throw new ApfloatArithmeticException("Inverse zeroth root", "inverseRoot.zeroth", new Object[0]);
        }
        if (z.imag().signum() == 0 && z.real().signum() > 0 && (k %= n) == 0L) {
            return new Apcomplex(ApfloatMath.inverseRoot(z.real(), n));
        }
        if (n < 0L) {
            return ApcomplexMath.inverseRootAbs(ApcomplexMath.inverseRootAbs(z, -n, k), 1L, 0L);
        }
        return ApcomplexMath.inverseRootAbs(z, n, k);
    }

    private static Apcomplex inverseRootAbs(Apcomplex z, long n, long k) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result;
        double angle;
        double doubleImag;
        double doubleReal;
        double magnitude;
        Apcomplex tweak;
        Apfloat tmpImag;
        Apfloat tmpReal;
        long doublePrecision;
        if (z.equals(Apcomplex.ONE) && k == 0L) {
            return z;
        }
        if (n == 2L && z.imag().signum() == 0 && z.real().signum() < 0) {
            Apfloat y = ApfloatMath.inverseRoot(z.real().negate(), n);
            return new Apcomplex(Apfloat.ZEROS[z.radix()], k == 0L ? y.negate() : y);
        }
        long targetPrecision = z.precision();
        if (targetPrecision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate inverse root to infinite precision", "inverseRoot.infinitePrecision", new Object[0]);
        }
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat divisor = ApfloatMath.abs(new Apfloat(n, Long.MAX_VALUE, z.radix()));
        double doubleN = Math.abs((double)n);
        long realScale = z.real().scale();
        long imagScale = z.imag().scale();
        long scale = Math.max(realScale, imagScale);
        long scaleDiff = scale - Math.min(realScale, imagScale);
        long precision = doublePrecision = (long)ApfloatHelper.getDoublePrecision(z.radix());
        long scaleQuot = scale / n;
        long scaleRem = scale - scaleQuot * n;
        double scaleRemFactor = Math.pow(z.radix(), (double)(-scaleRem) / doubleN);
        if (z.imag().signum() == 0 || (scaleDiff > doublePrecision / 2L || scaleDiff < 0L) && realScale > imagScale) {
            double d;
            tmpReal = z.real().precision(doublePrecision);
            tmpImag = z.imag().precision(doublePrecision);
            tweak = new Apcomplex(Apfloat.ZERO, tmpImag.divide(divisor.multiply(tmpReal)));
            tmpReal = ApfloatMath.scale(tmpReal, -tmpReal.scale());
            magnitude = tmpReal.doubleValue();
            if (d >= 0.0) {
                doubleReal = Math.pow(magnitude, -1.0 / doubleN) * scaleRemFactor;
                doubleImag = 0.0;
            } else {
                magnitude = Math.pow(-magnitude, -1.0 / doubleN) * scaleRemFactor;
                angle = (tmpImag.signum() >= 0 ? -Math.PI : Math.PI) / doubleN;
                doubleReal = magnitude * Math.cos(angle);
                doubleImag = magnitude * Math.sin(angle);
            }
            tmpReal = ApfloatMath.scale(new Apfloat(doubleReal, doublePrecision, z.radix()), -scaleQuot);
            tmpImag = ApfloatMath.scale(new Apfloat(doubleImag, doublePrecision, z.radix()), -scaleQuot);
            result = new Apcomplex(tmpReal, tmpImag);
            result = result.subtract(result.multiply(tweak));
        } else if (z.real().signum() == 0 || (scaleDiff > doublePrecision / 2L || scaleDiff < 0L) && imagScale > realScale) {
            double d;
            tmpReal = z.real().precision(doublePrecision);
            tmpImag = z.imag().precision(doublePrecision);
            tweak = new Apcomplex(Apfloat.ZERO, tmpReal.divide(divisor.multiply(tmpImag)));
            tmpImag = ApfloatMath.scale(tmpImag, -tmpImag.scale());
            magnitude = tmpImag.doubleValue();
            if (d >= 0.0) {
                magnitude = Math.pow(magnitude, -1.0 / doubleN) * scaleRemFactor;
                angle = -Math.PI / (2.0 * doubleN);
            } else {
                magnitude = Math.pow(-magnitude, -1.0 / doubleN) * scaleRemFactor;
                angle = Math.PI / (2.0 * doubleN);
            }
            doubleReal = magnitude * Math.cos(angle);
            doubleImag = magnitude * Math.sin(angle);
            tmpReal = ApfloatMath.scale(new Apfloat(doubleReal, doublePrecision, z.radix()), -scaleQuot);
            tmpImag = ApfloatMath.scale(new Apfloat(doubleImag, doublePrecision, z.radix()), -scaleQuot);
            result = new Apcomplex(tmpReal, tmpImag);
            result = result.add(result.multiply(tweak));
        } else {
            tmpReal = z.real().precision(doublePrecision);
            tmpImag = z.imag().precision(doublePrecision);
            tmpReal = ApfloatMath.scale(tmpReal, -scale);
            tmpImag = ApfloatMath.scale(tmpImag, -scale);
            doubleReal = tmpReal.doubleValue();
            doubleImag = tmpImag.doubleValue();
            magnitude = Math.pow(doubleReal * doubleReal + doubleImag * doubleImag, -1.0 / (2.0 * doubleN)) * scaleRemFactor;
            angle = -Math.atan2(doubleImag, doubleReal) / doubleN;
            doubleReal = magnitude * Math.cos(angle);
            doubleImag = magnitude * Math.sin(angle);
            tmpReal = ApfloatMath.scale(new Apfloat(doubleReal, doublePrecision, z.radix()), -scaleQuot);
            tmpImag = ApfloatMath.scale(new Apfloat(doubleImag, doublePrecision, z.radix()), -scaleQuot);
            result = new Apcomplex(tmpReal, tmpImag);
        }
        if (k != 0L) {
            Apcomplex branch;
            long l = k = k < 0L ? k + n : k;
            if (n % 4L == 0L && n >>> 2 == k) {
                branch = new Apcomplex(Apfloat.ZERO, one);
            } else if (n % 4L == 0L && (n >>> 2) * 3L == k) {
                branch = new Apcomplex(Apfloat.ZERO, one.negate());
            } else if (n % 2L == 0L && n >>> 1 == k) {
                branch = one.negate();
            } else {
                angle = Math.PI * 2 * (double)k / doubleN;
                doubleReal = Math.cos(angle);
                doubleImag = Math.sin(angle);
                Apfloat tmpReal2 = new Apfloat(doubleReal, doublePrecision, z.radix());
                Apfloat tmpImag2 = new Apfloat(doubleImag, doublePrecision, z.radix());
                branch = new Apcomplex(tmpReal2, tmpImag2);
            }
            result = result.multiply(z.imag().signum() >= 0 ? branch.conj() : branch);
        }
        int iterations = 0;
        for (long maxPrec = precision; maxPrec < targetPrecision; maxPrec <<= 1) {
            ++iterations;
        }
        int precisingIteration = iterations;
        long minPrec = precision;
        while (precisingIteration > 0 && minPrec - 20L << precisingIteration < targetPrecision) {
            --precisingIteration;
            minPrec <<= 1;
        }
        z = ApfloatHelper.extendPrecision(z);
        while (iterations-- > 0) {
            result = ApfloatHelper.setPrecision(result, Math.min(precision *= 2L, targetPrecision));
            Apcomplex t = ApcomplexMath.powAbs(result, n);
            t = ApcomplexMath.lastIterationExtendPrecision(iterations, precisingIteration, t);
            t = one.subtract(z.multiply(t));
            if (iterations < precisingIteration) {
                t = new Apcomplex(t.real().precision(precision / 2L), t.imag().precision(precision / 2L));
            }
            result = ApcomplexMath.lastIterationExtendPrecision(iterations, precisingIteration, result);
            result = result.add(result.multiply(t).divide(divisor));
            if (iterations != precisingIteration) continue;
            t = ApcomplexMath.powAbs(result, n);
            t = ApcomplexMath.lastIterationExtendPrecision(iterations, -1, t);
            result = ApcomplexMath.lastIterationExtendPrecision(iterations, -1, result);
            result = result.add(result.multiply(one.subtract(z.multiply(t))).divide(divisor));
        }
        return ApfloatHelper.setPrecision(result, targetPrecision);
    }

    public static Apcomplex[] allRoots(Apcomplex z, int n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0) {
            throw new ApfloatArithmeticException("Zeroth root", "root.zeroth", new Object[0]);
        }
        if (n == 1) {
            return new Apcomplex[]{z};
        }
        if (n == Integer.MIN_VALUE) {
            throw new ApfloatRuntimeException("Maximum array size exceeded: " + -((long)n), "maximumArraySizeExceeded", -((long)n));
        }
        if (z.isZero()) {
            if (n < 0) {
                throw new ApfloatArithmeticException("Inverse root of zero", "inverseRoot.ofZero", new Object[0]);
            }
            Object[] allRoots = new Apcomplex[n];
            Arrays.fill(allRoots, Apcomplex.ZEROS[z.radix()]);
            return allRoots;
        }
        boolean inverse = n < 0;
        n = Math.abs(n);
        long precision = z.precision();
        z = ApfloatHelper.extendPrecision(z);
        Apcomplex w = ApcomplexMath.inverseRootAbs(new Apfloat(1L, precision, z.radix()), n, 1L);
        w = z.imag().signum() >= 0 ^ inverse ? w.conj() : w;
        Apcomplex[] allRoots = new Apcomplex[n];
        Apcomplex root = inverse ? ApcomplexMath.inverseRootAbs(z, n, 0L) : ApcomplexMath.root(z, n);
        allRoots[0] = ApfloatHelper.setPrecision(root, precision);
        for (int i = 1; i < n; ++i) {
            root = root.multiply(w);
            allRoots[i] = ApfloatHelper.setPrecision(root, precision);
        }
        return allRoots;
    }

    public static Apcomplex agm(Apcomplex a, Apcomplex b) throws ApfloatRuntimeException {
        return ApcomplexMath.agm(a, b, null);
    }

    static Apcomplex agm(Apcomplex a, Apcomplex b, Consumer<Apcomplex> consumer) throws ApfloatRuntimeException {
        Apcomplex t;
        long workingPrecision;
        if (a.isZero() || b.isZero()) {
            return Apcomplex.ZEROS[a.radix()];
        }
        if (a.real().signum() == b.real().signum() && a.imag().signum() == 0 && b.imag().signum() == 0) {
            return ApfloatMath.agm(a.real(), b.real(), consumer == null ? null : consumer::accept);
        }
        if (a.equals(b)) {
            return a.precision(Math.min(a.precision(), b.precision()));
        }
        if (a.equals(b.negate())) {
            return Apcomplex.ZEROS[a.radix()];
        }
        long targetPrecision = workingPrecision = Math.min(a.precision(), b.precision());
        if (workingPrecision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate agm to infinite precision", "agm.infinitePrecision", new Object[0]);
        }
        workingPrecision = ApfloatHelper.extendPrecision(workingPrecision);
        a = ApfloatHelper.ensurePrecision(a, workingPrecision);
        b = ApfloatHelper.ensurePrecision(b, workingPrecision);
        long precision = 0L;
        long halfWorkingPrecision = (workingPrecision + 1L) / 2L;
        long CONVERGING = 1000L;
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, a.radix());
        Apcomplex c2 = null;
        if (consumer != null) {
            c2 = ApfloatHelper.ensurePrecision(a.multiply(a).subtract(b.multiply(b)), workingPrecision);
            consumer.accept(c2);
        }
        while (precision < 1000L && precision < halfWorkingPrecision) {
            t = ApcomplexMath.limitPrecision(a.add(b)).divide(two);
            b = ApcomplexMath.rightSqrt(a.multiply(b), t);
            a = t;
            a = ApfloatHelper.ensurePrecision(a, workingPrecision);
            b = ApfloatHelper.ensurePrecision(b, workingPrecision);
            precision = a.equalDigits(b);
            c2 = ApcomplexMath.agmConsume(consumer, a, c2, workingPrecision);
        }
        while (precision <= halfWorkingPrecision) {
            t = a.add(b).divide(two);
            b = ApcomplexMath.rightSqrt(a.multiply(b), t);
            a = t;
            a = ApfloatHelper.ensurePrecision(a, workingPrecision);
            b = ApfloatHelper.ensurePrecision(b, workingPrecision);
            precision *= 2L;
            c2 = ApcomplexMath.agmConsume(consumer, a, c2, workingPrecision);
        }
        Apcomplex result = a.add(b).divide(two);
        ApcomplexMath.agmConsume(consumer, result, c2, workingPrecision);
        return ApfloatHelper.setPrecision(result, targetPrecision);
    }

    private static Apcomplex limitPrecision(Apcomplex z) {
        return z.precision(z.precision());
    }

    private static Apcomplex rightSqrt(Apcomplex z, Apcomplex reference) {
        Apcomplex result = ApcomplexMath.sqrt(z);
        int doublePrecision = ApfloatHelper.getDoublePrecision(z.radix());
        Apcomplex approxResult = result.precision(doublePrecision);
        Apcomplex approxReference = reference.precision(doublePrecision);
        int comparison = ApcomplexMath.norm(approxReference.subtract(approxResult)).compareTo(ApcomplexMath.norm(approxReference.add(approxResult)));
        if (comparison == 0) {
            comparison = ApcomplexMath.norm(reference.subtract(result)).compareTo(ApcomplexMath.norm(reference.add(result)));
        }
        if (comparison > 0 || comparison == 0 && result.divide(reference).imag().signum() <= 0) {
            result = result.negate();
        }
        return result;
    }

    private static Apcomplex agmConsume(Consumer<Apcomplex> consumer, Apcomplex a, Apcomplex c2, long workingPrecision) {
        if (consumer != null) {
            Apfloat four = new Apfloat(4L, Long.MAX_VALUE, a.radix());
            Apcomplex c = ApfloatHelper.ensurePrecision(c2.divide(four.multiply(a)), workingPrecision);
            c2 = ApfloatHelper.ensurePrecision(c.multiply(c), workingPrecision);
            consumer.accept(c2);
        }
        return c2;
    }

    public static Apcomplex log(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat radixPower;
        Apfloat imagBias;
        if (z.imag().signum() == 0) {
            if (z.real().signum() >= 0) {
                return ApfloatMath.log(z.real());
            }
            return new Apcomplex(ApfloatMath.log(z.real().negate()), ApfloatMath.pi(z.precision(), z.radix()));
        }
        long targetPrecision = z.precision();
        if (targetPrecision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate logarithm to infinite precision", "log.infinitePrecision", new Object[0]);
        }
        Apfloat x = ApcomplexMath.abs(z);
        if (x.scale() > 1L) {
            double logScale = Math.log((double)x.scale() - 1.0) / Math.log(x.radix());
            logScale += Math.ulp(logScale);
            targetPrecision = Util.ifFinite(targetPrecision, targetPrecision + (long)logScale);
        }
        if (z.real().signum() < 0) {
            Apfloat pi = ApfloatHelper.extendPrecision(ApfloatMath.pi(targetPrecision, z.radix()), z.radix() <= 3 ? 1L : 0L);
            imagBias = z.imag().signum() >= 0 ? pi : pi.negate();
            z = z.negate();
        } else {
            imagBias = Apfloat.ZERO;
        }
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        long originalScale = z.scale();
        z = ApcomplexMath.scale(z, -originalScale);
        if (originalScale == 0L) {
            radixPower = Apfloat.ZERO;
        } else {
            Apfloat logRadix = ApfloatHelper.extendPrecision(ApfloatMath.logRadix(targetPrecision, z.radix()));
            radixPower = new Apfloat(originalScale, Long.MAX_VALUE, z.radix()).multiply(logRadix);
        }
        Apcomplex result = ApfloatHelper.extendPrecision(ApcomplexMath.rawLog(z)).add(radixPower);
        long finalRealPrecision = Math.max(targetPrecision - one.equalDigits(x), 1L);
        long finalImagPrecision = Math.max(targetPrecision - 1L + result.imag().scale(), 1L);
        return new Apcomplex(result.real().precision(finalRealPrecision), result.imag().precision(finalImagPrecision).add(imagBias));
    }

    public static Apcomplex log(Apcomplex z, Apcomplex w) throws ArithmeticException, ApfloatRuntimeException {
        if (z.real().signum() >= 0 && z.imag().signum() == 0 && w.real().signum() >= 0 && w.imag().signum() == 0) {
            return ApfloatMath.log(z.real(), w.real());
        }
        long targetPrecision = Math.min(z.precision(), w.precision());
        if (z.real().signum() >= 0 && z.imag().signum() == 0) {
            Apfloat x = z.real();
            Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x.radix());
            targetPrecision = Util.ifFinite(targetPrecision, targetPrecision + one.equalDigits(x));
            x = x.precision(Math.min(x.precision(), targetPrecision));
            return ApfloatMath.log(x).divide(ApcomplexMath.log(w));
        }
        if (w.real().signum() >= 0 && w.imag().signum() == 0) {
            Apfloat y = w.real();
            Apfloat one = new Apfloat(1L, Long.MAX_VALUE, y.radix());
            targetPrecision = Util.ifFinite(targetPrecision, targetPrecision + one.equalDigits(y));
            y = y.precision(Math.min(y.precision(), targetPrecision));
            return ApcomplexMath.log(z).divide(ApfloatMath.log(y));
        }
        return ApcomplexMath.log(z).divide(ApcomplexMath.log(w));
    }

    private static Apcomplex rawLog(Apcomplex z) throws ApfloatRuntimeException {
        assert (!z.isZero());
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        int EXTRA_PRECISION = 25;
        long targetPrecision = z.precision();
        long workingPrecision = ApfloatHelper.extendPrecision(targetPrecision);
        long n = targetPrecision / 2L + 25L;
        z = ApfloatHelper.extendPrecision(z, 25L);
        Apfloat e = one.precision(workingPrecision);
        e = ApfloatMath.scale(e, -n);
        z = ApcomplexMath.scale(z, -n);
        Apfloat agme = ApfloatHelper.extendPrecision(ApfloatMath.agm(one, e));
        Apcomplex agmez = ApfloatHelper.extendPrecision(ApcomplexMath.agm(one, z));
        Apfloat pi = ApfloatHelper.extendPrecision(ApfloatMath.pi(targetPrecision, z.radix()));
        Apcomplex log = pi.multiply(agmez.subtract(agme)).divide(new Apfloat(2L, Long.MAX_VALUE, z.radix()).multiply(agme).multiply(agmez));
        return ApfloatHelper.setPrecision(log, targetPrecision);
    }

    public static Apcomplex exp(Apcomplex z) throws ApfloatRuntimeException {
        Apcomplex resultImag;
        Apfloat resultReal;
        Apfloat zImag;
        long imagPrecision;
        if (z.imag().signum() == 0) {
            return ApfloatMath.exp(z.real());
        }
        int radix = z.radix();
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, radix);
        long doublePrecision = ApfloatHelper.getDoublePrecision(radix);
        if (z.real().compareTo(new Apfloat(-9.223372036854776E18 * Math.log(radix), doublePrecision, radix)) <= 0) {
            return Apcomplex.ZEROS[z.radix()];
        }
        if (z.real().precision() < z.real().scale() - 1L) {
            throw new LossOfPrecisionException("Complete loss of accurate digits in real part", "real.lossOfPrecision", new Object[0]);
        }
        if (z.imag().precision() < z.imag().scale()) {
            throw new LossOfPrecisionException("Complete loss of accurate digits in imaginary part", "imag.lossOfPrecision", new Object[0]);
        }
        long realPrecision = Util.ifFinite(z.real().precision(), z.real().precision() + 1L - z.real().scale());
        long targetPrecision = Math.min(realPrecision, imagPrecision = Util.ifFinite(z.imag().precision(), 1L + z.imag().precision() - z.imag().scale()));
        if (targetPrecision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate exponent to infinite precision", "exp.infinitePrecision", new Object[0]);
        }
        if (z.real().compareTo(new Apfloat(9.223372036854776E18 * Math.log(radix), doublePrecision, radix)) >= 0) {
            throw new OverflowException("Overflow", "overflow", new Object[0]);
        }
        boolean negateResult = false;
        if (z.imag().scale() > 0L) {
            long piPrecision = Util.ifFinite(targetPrecision, targetPrecision + z.imag().scale());
            Apfloat pi = ApfloatMath.pi(piPrecision, radix);
            Apfloat twoPi = pi.add(pi);
            Apfloat halfPi = pi.divide(new Apfloat(2L, targetPrecision, radix));
            zImag = ApfloatMath.fmod(z.imag(), twoPi);
            if (zImag.compareTo(pi) > 0) {
                zImag = zImag.subtract(twoPi);
            } else if (zImag.compareTo(pi.negate()) <= 0) {
                zImag = zImag.add(twoPi);
            }
            if (zImag.compareTo(halfPi) > 0) {
                zImag = zImag.subtract(pi);
                negateResult = true;
            } else if (zImag.compareTo(halfPi.negate()) <= 0) {
                zImag = zImag.add(pi);
                negateResult = true;
            }
        } else {
            zImag = z.imag();
        }
        z = new Apcomplex(z.real(), zImag);
        if (z.real().signum() == 0) {
            resultReal = one;
        } else if (z.real().scale() < -doublePrecision / 2L) {
            long precision = Util.ifFinite(-z.real().scale(), -2L * z.real().scale());
            resultReal = one.precision(precision).add(z.real());
        } else {
            long scaledRealPrecision = Math.max(0L, z.real().scale()) + doublePrecision;
            Apfloat logRadix = ApfloatMath.log(new Apfloat((double)radix, scaledRealPrecision, radix));
            Apfloat scaledReal = z.real().precision(scaledRealPrecision).divide(logRadix);
            Apint integerPart = scaledReal.truncate();
            Apfloat fractionalPart = scaledReal.frac();
            resultReal = new Apfloat(Math.pow(radix, fractionalPart.doubleValue()), doublePrecision, radix);
            if ((resultReal = ApfloatMath.scale(resultReal, integerPart.longValue())).signum() == 0) {
                return Apcomplex.ZEROS[z.radix()];
            }
        }
        if (zImag.signum() == 0) {
            resultImag = one;
        } else if (zImag.scale() < -doublePrecision / 2L) {
            long precision = Util.ifFinite(-zImag.scale(), -2L * zImag.scale());
            resultImag = new Apcomplex(one.precision(precision), zImag.precision(-zImag.scale()));
        } else {
            double doubleImag = zImag.doubleValue();
            resultImag = new Apcomplex(new Apfloat(Math.cos(doubleImag), doublePrecision, radix), new Apfloat(Math.sin(doubleImag), doublePrecision, radix));
        }
        Apcomplex result = resultReal.multiply(resultImag);
        long precision = result.precision();
        int iterations = 0;
        for (long maxPrec = precision; maxPrec < targetPrecision; maxPrec <<= 1) {
            ++iterations;
        }
        int precisingIteration = iterations;
        long minPrec = precision;
        while (precisingIteration > 0 && minPrec - 20L << precisingIteration < targetPrecision) {
            --precisingIteration;
            minPrec <<= 1;
        }
        if (iterations > 0) {
            ApfloatMath.logRadix(targetPrecision, radix);
        }
        z = ApfloatHelper.extendPrecision(z);
        while (iterations-- > 0) {
            result = ApfloatHelper.setPrecision(result, Math.min(precision *= 2L, targetPrecision));
            Apcomplex t = ApcomplexMath.log(result);
            t = ApcomplexMath.lastIterationExtendPrecision(iterations, precisingIteration, t);
            t = z.subtract(t);
            if (iterations < precisingIteration) {
                t = new Apcomplex(t.real().precision(precision / 2L), t.imag().precision(precision / 2L));
            }
            result = ApcomplexMath.lastIterationExtendPrecision(iterations, precisingIteration, result);
            result = result.add(result.multiply(t));
            if (iterations != precisingIteration) continue;
            t = ApcomplexMath.log(result);
            t = ApcomplexMath.lastIterationExtendPrecision(iterations, -1, t);
            result = ApcomplexMath.lastIterationExtendPrecision(iterations, -1, result);
            result = result.add(result.multiply(z.subtract(t)));
        }
        return ApfloatHelper.setPrecision(negateResult ? result.negate() : result, targetPrecision);
    }

    public static Apcomplex pow(Apcomplex z, Apcomplex w) throws ApfloatRuntimeException {
        long targetPrecision = Math.min(z.precision(), w.precision());
        Apcomplex result = ApfloatHelper.checkPow(z, w, targetPrecision);
        if (result != null) {
            return result;
        }
        if (z.real().signum() >= 0 && z.imag().signum() == 0) {
            Apfloat x = z.real();
            Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x.radix());
            targetPrecision = Util.ifFinite(targetPrecision, targetPrecision + one.equalDigits(x));
            x = x.precision(Math.min(x.precision(), targetPrecision));
            return ApcomplexMath.exp(w.multiply(ApfloatMath.log(x)));
        }
        return ApcomplexMath.exp(w.multiply(ApcomplexMath.log(z)));
    }

    public static Apcomplex acos(Apcomplex z) throws ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        if (z.imag().signum() == 0 && ApfloatMath.abs(z.real()).compareTo(one) <= 0) {
            return ApfloatMath.acos(z.real());
        }
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        Apcomplex w = z.real().signum() > 0 || z.real().signum() == 0 && z.imag().signum() > 0 ? i.multiply(ApcomplexMath.log(z.add(ApcomplexMath.sqrt(z.multiply(z).subtract(one))))) : i.multiply(ApcomplexMath.log(z.subtract(ApcomplexMath.sqrt(z.multiply(z).subtract(one)))));
        if (z.imag().signum() < 0 || z.imag().signum() == 0 && z.real().signum() > 0) {
            return w;
        }
        return w.negate();
    }

    static Apcomplex acos(Apcomplex z, long precision) {
        if (z.isZero()) {
            return ApfloatMath.halfPi(z.radix(), precision);
        }
        return ApcomplexMath.acos(z);
    }

    public static Apcomplex acosh(Apcomplex z) throws ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        if (z.real().signum() > 0 || z.real().signum() == 0 && z.imag().signum() >= 0) {
            return ApcomplexMath.log(z.add(ApcomplexMath.sqrt(z.multiply(z).subtract(one))));
        }
        return ApcomplexMath.log(z.subtract(ApcomplexMath.sqrt(z.multiply(z).subtract(one))));
    }

    static Apcomplex acosh(Apcomplex z, long precision) {
        if (z.isZero()) {
            return new Apcomplex(Apfloat.ZEROS[z.radix()], ApfloatMath.halfPi(z.radix(), precision));
        }
        return ApcomplexMath.acosh(z);
    }

    public static Apcomplex asin(Apcomplex z) throws ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        if (z.imag().signum() == 0 && ApfloatMath.abs(z.real()).compareTo(one) <= 0) {
            return ApfloatMath.asin(z.real());
        }
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        if (z.imag().signum() > 0 || z.imag().signum() == 0 && z.real().signum() < 0) {
            return i.multiply(ApcomplexMath.log(ApcomplexMath.sqrt(one.subtract(z.multiply(z))).subtract(i.multiply(z))));
        }
        return i.multiply(ApcomplexMath.log(i.multiply(z).add(ApcomplexMath.sqrt(one.subtract(z.multiply(z)))))).negate();
    }

    public static Apcomplex asinh(Apcomplex z) throws ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        if (z.real().signum() > 0 || z.real().signum() == 0 && z.imag().signum() > 0) {
            return ApcomplexMath.log(ApcomplexMath.sqrt(z.multiply(z).add(one)).add(z));
        }
        return ApcomplexMath.log(ApcomplexMath.sqrt(z.multiply(z).add(one)).subtract(z)).negate();
    }

    public static Apcomplex atan(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        if (z.imag().signum() == 0) {
            return ApfloatMath.atan(z.real());
        }
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, z.radix());
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        Apcomplex w = ApcomplexMath.log(i.add(z).divide(i.subtract(z))).multiply(i).divide(two);
        if (z.real().signum() == 0 && z.imag().signum() > 0) {
            return new Apcomplex(w.real().negate(), w.imag());
        }
        return w;
    }

    public static Apcomplex atanh(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, z.radix());
        Apcomplex w = ApcomplexMath.log(one.add(z).divide(one.subtract(z))).divide(two);
        if (z.real().signum() > 0 && z.imag().signum() == 0) {
            return w.conj();
        }
        return w;
    }

    public static Apcomplex cos(Apcomplex z) throws ApfloatRuntimeException {
        if (z.imag().signum() == 0) {
            return ApfloatMath.cos(z.real());
        }
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, z.radix());
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        Apcomplex w = ApcomplexMath.exp(i.multiply(z));
        return w.add(one.divide(w)).divide(two);
    }

    public static Apcomplex cosh(Apcomplex z) throws ApfloatRuntimeException {
        if (z.imag().signum() == 0) {
            return ApfloatMath.cosh(z.real());
        }
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, z.radix());
        Apcomplex w = ApcomplexMath.exp(z);
        return w.add(one.divide(w)).divide(two);
    }

    public static Apcomplex sin(Apcomplex z) throws ApfloatRuntimeException {
        if (z.imag().signum() == 0) {
            return ApfloatMath.sin(z.real());
        }
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, z.radix());
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        Apcomplex w = ApcomplexMath.exp(i.multiply(z));
        return one.divide(w).subtract(w).multiply(i).divide(two);
    }

    public static Apcomplex sinh(Apcomplex z) throws ApfloatRuntimeException {
        if (z.imag().signum() == 0) {
            return ApfloatMath.sinh(z.real());
        }
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, z.radix());
        Apcomplex w = ApcomplexMath.exp(z);
        return w.subtract(one.divide(w)).divide(two);
    }

    public static Apcomplex tan(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.tan(z, z.imag().signum() < 0);
    }

    static Apcomplex tanFixedPrecision(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.tan(z, z.imag().signum() > 0);
    }

    static Apcomplex tan(Apcomplex z, boolean negate) throws ArithmeticException, ApfloatRuntimeException {
        if (z.imag().signum() == 0) {
            return ApfloatMath.tan(z.real());
        }
        z = negate ? z.negate() : z;
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, z.radix());
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        Apcomplex w = ApcomplexMath.exp(two.multiply(i).multiply(z));
        w = i.multiply(one.subtract(w)).divide(one.add(w));
        return negate ? w.negate() : w;
    }

    public static Apcomplex tanh(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.tanh(z, z.real().signum() > 0);
    }

    static Apcomplex tanhFixedPrecision(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.tanh(z, z.real().signum() < 0);
    }

    private static Apcomplex tanh(Apcomplex z, boolean negate) throws ArithmeticException, ApfloatRuntimeException {
        if (z.imag().signum() == 0) {
            return ApfloatMath.tanh(z.real());
        }
        z = negate ? z.negate() : z;
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, z.radix());
        Apcomplex w = ApcomplexMath.exp(two.multiply(z));
        w = w.subtract(one).divide(w.add(one));
        return negate ? w.negate() : w;
    }

    static Apcomplex cot(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        if (z.imag().isZero()) {
            Apcomplex w = ApcomplexMath.exp(new Apcomplex(Apfloat.ZERO, z.real()));
            return w.real().divide(w.imag());
        }
        boolean negate = z.imag().signum() < 0;
        z = negate ? z.negate() : z;
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, z.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, z.radix());
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        Apcomplex w = ApcomplexMath.expNoLoP(two.multiply(i).multiply(z));
        w = i.multiply(two.multiply(w).divide(w.subtract(one)).subtract(one));
        return negate ? w.negate() : w;
    }

    public static Apcomplex sinc(Apcomplex z) throws ApfloatRuntimeException {
        if (z.isZero()) {
            return Apcomplex.ONES[z.radix()];
        }
        return ApcomplexMath.sin(z).divide(z);
    }

    public static Apcomplex w(Apcomplex z) throws ApfloatRuntimeException {
        return LambertWHelper.w(z);
    }

    public static Apcomplex w(Apcomplex z, long k) throws ArithmeticException, ApfloatRuntimeException {
        return LambertWHelper.w(z, k);
    }

    public static Apcomplex product(Apcomplex ... z) throws ApfloatRuntimeException {
        if (z.length == 0) {
            return Apcomplex.ONE;
        }
        long maxPrec = Long.MAX_VALUE;
        for (int i = 0; i < z.length; ++i) {
            if (z[i].real().signum() == 0 && z[i].imag().signum() == 0) {
                return Apcomplex.ZEROS[z[i].radix()];
            }
            maxPrec = Math.min(maxPrec, z[i].precision());
        }
        Apcomplex[] tmp = new Apcomplex[z.length];
        long extraPrec = (long)Math.sqrt(z.length);
        long destPrec = ApfloatHelper.extendPrecision(maxPrec, extraPrec);
        for (int i = 0; i < z.length; ++i) {
            tmp[i] = z[i].precision(destPrec);
        }
        z = tmp;
        PriorityQueue<Apcomplex> heap = new PriorityQueue<Apcomplex>(z.length, Comparator.comparing(Apcomplex::size));
        ParallelHelper.ProductKernel kernel = h -> {
            Apcomplex a = (Apcomplex)h.remove();
            Apcomplex b = (Apcomplex)h.remove();
            Apcomplex c = a.multiply(b);
            h.add(c);
        };
        ParallelHelper.parallelProduct((Apcomplex[])z, heap, kernel);
        return ApfloatHelper.setPrecision((Apcomplex)heap.remove(), maxPrec);
    }

    public static Apcomplex sum(Apcomplex ... z) throws ApfloatRuntimeException {
        if (z.length == 0) {
            return Apcomplex.ZERO;
        }
        Apfloat[] x = new Apfloat[z.length];
        Apfloat[] y = new Apfloat[z.length];
        for (int i = 0; i < z.length; ++i) {
            x[i] = z[i].real();
            y[i] = z[i].imag();
        }
        return new Apcomplex(ApfloatMath.sum(x), ApfloatMath.sum(y));
    }

    public static Apcomplex gamma(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat c0;
        if (z.equals(Apfloat.ONE)) {
            return z;
        }
        long precision = z.precision();
        int radix = z.radix();
        Apint one = Apint.ONES[radix];
        if (z.scale() < -precision) {
            return one.divide(z);
        }
        if (z.imag().signum() == 0) {
            if (z.real().signum() == 0) {
                throw new ApfloatArithmeticException("Gamma of zero", "gamma.ofZero", new Object[0]);
            }
            if (z.real().isInteger()) {
                if (z.real().signum() < 0) {
                    throw new ApfloatArithmeticException("Gamma of negative integer", "gamma.ofNegativeInteger", new Object[0]);
                }
                long n = ApfloatHelper.longValueExact(z.real().truncate());
                double gammaEffort = Math.log(precision) * (double)precision * (double)precision;
                double factorialEffort = Math.log(precision) * (double)precision * Math.log(n) * (double)n / 2000000.0;
                if (factorialEffort < gammaEffort) {
                    return ApfloatMath.factorial(n - 1L, precision, radix);
                }
            }
        }
        if (precision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate gamma function to infinite precision", "gamma.infinitePrecision", new Object[0]);
        }
        if (z.real().signum() < 0) {
            long targetPrecision = precision;
            Apint zRounded = RoundingHelper.roundToInteger(z.real(), RoundingMode.HALF_EVEN).truncate();
            if (zRounded.signum() < 0) {
                long digitLoss = -z.subtract(zRounded).scale();
                if (digitLoss >= targetPrecision) {
                    throw new ApfloatArithmeticException("Gamma of negative integer within precision", "gamma.ofNegativeIntegerWithinPrecision", new Object[0]);
                }
                if (digitLoss > 0L) {
                    targetPrecision -= digitLoss;
                }
            }
            precision = ApfloatHelper.extendPrecision(precision, ApfloatHelper.getSmallExtraPrecision(radix));
            z = ApfloatHelper.ensurePrecision(z.negate(), precision);
            Apfloat pi = ApfloatMath.pi(precision, radix);
            return ApfloatHelper.limitPrecision(pi.negate().divide(z.multiply(ApcomplexMath.sin(pi.multiply(z))).multiply(ApcomplexMath.gamma(z))), targetPrecision);
        }
        long a1 = (long)((double)precision / Math.log(Math.PI * 2) * Math.log(radix));
        long workingPrecision = ApfloatHelper.extendPrecision(precision, (long)((double)precision * 0.5) + 20L);
        z = ApfloatHelper.ensurePrecision(z, workingPrecision).subtract(one);
        Apfloat a = new Apint(a1 + 1L, radix);
        Apint two = new Apint(2L, radix);
        Apcomplex sum = c0 = ApfloatMath.sqrt(ApfloatMath.pi(workingPrecision, radix).multiply(two));
        Apfloat e = ApfloatMath.exp(one.precision(workingPrecision));
        Apfloat divisor = ApfloatMath.exp(new Apfloat(-a1, workingPrecision, radix));
        for (long k = 1L; k <= a1; ++k) {
            Apint kk = new Apint(k, radix);
            Apfloat ak = a.subtract(kk).precision(workingPrecision);
            Apfloat ck = ApfloatMath.inverseRoot(ak, 2L).multiply(ApfloatMath.pow(ak, k)).divide(divisor);
            sum = sum.add(ck.divide(z.add(kk)));
            if (k >= a1) continue;
            divisor = divisor.multiply(e).multiply(kk).negate();
        }
        a = a.precision(workingPrecision);
        Apfloat half = new Aprational(one, two).precision(workingPrecision);
        Apcomplex result = ApcomplexMath.pow(z.add(a), z.add(half)).multiply(ApcomplexMath.exp(z.negate().subtract(a))).multiply(sum);
        double normalizedScale = (double)result.scale() * Math.log(radix);
        if (normalizedScale > 0.0 && z.real().scale() > 0L) {
            precision -= (long)(1.01 * Math.log(normalizedScale) / Math.log(radix));
        } else if (normalizedScale < 0.0) {
            precision -= (long)(1.148 * Math.log(-normalizedScale) / Math.log(radix));
        }
        if (precision <= 0L) {
            throw new LossOfPrecisionException("Complete loss of accurate digits", "lossOfPrecision", new Object[0]);
        }
        return ApfloatHelper.limitPrecision(result, precision);
    }

    public static Apcomplex gamma(Apcomplex a, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return IncompleteGammaHelper.gamma(a, z);
    }

    public static Apcomplex gamma(Apcomplex a, Apcomplex z0, Apcomplex z1) throws ArithmeticException, ApfloatRuntimeException {
        return IncompleteGammaHelper.gamma(a, z0, z1);
    }

    public static Apcomplex logGamma(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        long precision = z.precision();
        if (z.imag().signum() == 0) {
            if (z.real().signum() == 0) {
                throw new ApfloatArithmeticException("Log gamma of zero", "logGamma.ofZero", new Object[0]);
            }
            if (z.real().isInteger() && z.real().signum() < 0) {
                throw new ApfloatArithmeticException("Log gamma of negative integer", "logGamma.ofNegativeInteger", new Object[0]);
            }
        }
        if (precision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate log gamma function to infinite precision", "logGamma.infinitePrecision", new Object[0]);
        }
        int radix = z.radix();
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        long workingPrecision = ApfloatHelper.extendPrecision(precision);
        Apfloat pi = ApfloatMath.pi(workingPrecision, radix);
        if (z.real().signum() <= 0) {
            long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
            Apcomplex result = (z = ApfloatHelper.extendPrecision(z, extraPrecision)).scale() < -precision ? ApcomplexMath.log(pi).subtract(ApcomplexMath.log(pi.multiply(z))).subtract(ApcomplexMath.logGamma(z.negate())).subtract(ApcomplexMath.log(z.negate())) : ApcomplexMath.log(pi).subtract(ApcomplexMath.logSin(z)).subtract(ApcomplexMath.logGamma(one.subtract(z)));
            return ApfloatHelper.reducePrecision(result, extraPrecision);
        }
        double adjust = Math.log(precision) + 1.0;
        double w = ((double)precision + adjust) * Math.log(radix) - Math.log(Math.PI * 2);
        long n = (long)Math.ceil(0.5 * (1.0 + w - Math.log(w)));
        Apfloat zReal = new Apfloat((double)n * Math.exp((4.0 * (double)n - 1.0) / ((double)(2L * n) - 4.0 * (double)n * (double)n)) / Math.PI, precision, radix);
        Apcomplex s = Apcomplex.ZERO;
        if (z.real().compareTo(zReal) < 0) {
            long N = zReal.subtract(z.real()).roundAway().longValueExact();
            s = s.subtract(ApcomplexMath.logPochhammer(z, N));
            z = z.add(new Apfloat(N, precision, radix));
        }
        s = s.add(z.subtract(new Aprational(one, two)).multiply(ApcomplexMath.log(z))).subtract(z).add(ApcomplexMath.log(two.multiply(pi)).divide(two));
        Apcomplex z2 = z.multiply(z);
        Apcomplex zp = z;
        Iterator<Apfloat> bernoulli2 = BernoulliHelper.bernoullis2(n, workingPrecision, radix);
        for (long k = 1L; k <= n; ++k) {
            long k2 = Util.multiplyExact(k, 2L);
            Apcomplex term = bernoulli2.next().divide(new Apint(k2, radix).multiply(new Apint(k2 - 1L, radix)).multiply(zp));
            if (k < n) {
                zp = zp.multiply(z2);
            }
            long[] matchingPrecisionsReal = ApfloatHelper.getMatchingPrecisions(s.real(), term.real());
            long[] matchingPrecisionsImag = ApfloatHelper.getMatchingPrecisions(s.imag(), term.imag());
            if (matchingPrecisionsReal[1] == 0L && matchingPrecisionsImag[1] == 0L) break;
            s = s.add(term);
        }
        return s;
    }

    private static Apcomplex logSin(Apcomplex z) {
        long precision = z.precision();
        long workingPrecision = ApfloatHelper.extendPrecision(precision);
        int radix = z.radix();
        Apint n = z.real().floor();
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apfloat half = new Aprational(one, two).precision(workingPrecision);
        Apfloat pi = ApfloatMath.pi(workingPrecision, radix);
        Apcomplex i = new Apcomplex(Apint.ZERO, Apint.ONES[radix]);
        Apcomplex offset = n.multiply(pi).multiply(i);
        assert (z.real().signum() <= 0);
        if (z.imag().signum() >= 0) {
            offset = offset.negate();
        }
        Apcomplex ls = (z = z.subtract(n)).imag().compareTo(one) > 0 ? ApcomplexMath.log(half.multiply(one.subtract(ApcomplexMath.expNoLoP(two.multiply(i).multiply(pi).multiply(z))))).subtract(i.multiply(pi).multiply(z.subtract(half))) : (z.imag().compareTo(one.negate()) < 0 ? ApcomplexMath.log(half.multiply(one.subtract(ApcomplexMath.expNoLoP(two.negate().multiply(i).multiply(pi).multiply(z))))).add(i.multiply(pi).multiply(z.subtract(half))) : ApcomplexMath.log(ApcomplexMath.sin(pi.multiply(z))));
        return ls.add(offset);
    }

    private static Apcomplex expNoLoP(Apcomplex z) {
        if (z.real().signum() < 0 && z.real().scale() > 1L && z.real().precision() <= z.real().scale() - 1L) {
            z = new Apcomplex(z.real().precision(z.real().scale()), z.imag());
        }
        return ApcomplexMath.exp(z);
    }

    private static Apcomplex logPochhammer(Apcomplex z, long n) {
        boolean conj;
        boolean bl = conj = z.imag().signum() < 0;
        if (conj) {
            z = z.conj();
        }
        int radix = z.radix();
        Apcomplex s = z;
        long m = 0L;
        for (long k = 1L; k < n; ++k) {
            Apcomplex t = s.multiply(z.add(new Apint(k, radix)));
            if (s.imag().signum() >= 0 && t.imag().signum() < 0) {
                m += 2L;
            }
            s = t;
        }
        if (s.real().signum() < 0) {
            m = s.imag().signum() >= 0 ? ++m : --m;
            s = s.negate();
        }
        Apcomplex i = new Apcomplex(Apint.ZERO, Apint.ONES[radix]);
        Apfloat pi = ApfloatMath.pi(z.precision(), radix);
        Apcomplex result = ApcomplexMath.log(s).add(pi.multiply(i).multiply(new Apint(m, radix)));
        return conj ? result.conj() : result;
    }

    public static Apcomplex digamma(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        long precision = z.precision();
        int radix = z.radix();
        Apint one = Apint.ONES[radix];
        if (z.real().signum() <= 0) {
            if (z.real().isInteger() && z.imag().signum() == 0) {
                throw new ApfloatArithmeticException("Digamma of nonpositive integer", "digamma.ofNonpositiveInteger", new Object[0]);
            }
            if (precision == Long.MAX_VALUE) {
                throw new InfiniteExpansionException("Cannot calculate digamma function to infinite precision", "digamma.infinitePrecision", new Object[0]);
            }
            long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
            precision = ApfloatHelper.extendPrecision(precision, extraPrecision);
            z = ApfloatHelper.ensurePrecision(z, precision);
            Apfloat pi = ApfloatMath.pi(precision, radix);
            Apcomplex result = z.scale() < -precision ? ApcomplexMath.digamma(z.negate()).subtract(pi.multiply(ApcomplexMath.cot(pi.multiply(z)))).subtract(one.divide(z)) : ApcomplexMath.digamma(one.subtract(z)).subtract(pi.multiply(ApcomplexMath.cot(pi.multiply(z))));
            return ApfloatHelper.reducePrecision(result, extraPrecision);
        }
        if (precision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate digamma function to infinite precision", "digamma.infinitePrecision", new Object[0]);
        }
        double adjust = Math.log(precision) + 1.0;
        double w = ((double)precision + adjust) * Math.log(radix) + 1.0;
        long n = (long)Math.ceil(0.5 * (w - Math.log(w)));
        Apfloat zReal = new Apfloat(Math.exp(-0.5 / (double)n) * (double)n / Math.PI, precision, radix);
        Apcomplex s = Apfloat.ZERO;
        if (z.real().compareTo(zReal) < 0) {
            long N = zReal.subtract(z.real()).roundAway().longValueExact();
            for (long k = 0L; k < N; ++k) {
                s = s.subtract(one.divide(z.add(new Apint(k, radix))));
            }
            z = z.add(new Apfloat(N, precision, radix));
        }
        Apint two = new Apint(2L, radix);
        s = s.add(ApcomplexMath.log(z)).subtract(one.divide(two.multiply(z)));
        Apcomplex z2 = z.multiply(z);
        Apcomplex zp = one;
        Iterator<Apfloat> bernoulli2 = BernoulliHelper.bernoullis2(n, precision, radix);
        for (long k = 1L; k <= n; ++k) {
            long k2 = Util.multiplyExact(k, 2L);
            zp = zp.multiply(z2);
            Apcomplex term = bernoulli2.next().divide(new Apint(k2, radix).multiply(zp));
            long[] matchingPrecisionsReal = ApfloatHelper.getMatchingPrecisions(s.real(), term.real());
            long[] matchingPrecisionsImag = ApfloatHelper.getMatchingPrecisions(s.imag(), term.imag());
            if (matchingPrecisionsReal[1] == 0L && matchingPrecisionsImag[1] == 0L) break;
            s = s.subtract(term);
        }
        return s;
    }

    public static Apcomplex polygamma(long n, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        if (n < 0L) {
            throw new ApfloatArithmeticException("Polygamma of negative order", "polygamma.ofNegativeOrder", new Object[0]);
        }
        if (ApcomplexMath.isNonPositiveInteger(z)) {
            throw new ApfloatArithmeticException("Polygamma of nonpositive integer", "polygamma.ofNonpositiveInteger", new Object[0]);
        }
        if (n == 0L) {
            return ApcomplexMath.digamma(z);
        }
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(z.precision(), extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint one = Apint.ONES[radix];
        if (z.real().signum() < 0 && -n / 10L > z.real().longValue()) {
            Apcomplex u;
            long n1 = Util.addExact(n, 1L);
            long cotPrecision = ApfloatHelper.extendPrecision(precision, (long)(Math.log(n) / Math.log(radix) + (double)z.scale()));
            Apint two = new Apint(2L, radix);
            Apfloat pi = ApfloatMath.pi(cotPrecision, radix);
            Apcomplex g = ApcomplexMath.polygamma(n, one.subtract(z));
            Apcomplex z2 = z.multiply(two);
            Apcomplex dz2 = z2.subtract(RoundingHelper.roundToInteger(z2.real(), RoundingMode.HALF_EVEN));
            if (!z.isInteger() && z2.isInteger()) {
                u = Apcomplex.ZEROS[radix];
            } else if (-dz2.scale() > cotPrecision / 2L) {
                dz2 = ApfloatHelper.ensurePrecision(dz2, cotPrecision);
                u = pi.multiply(dz2.divide(two)).negate();
            } else {
                z = ApfloatHelper.ensurePrecision(z, cotPrecision);
                u = ApcomplexMath.cot(pi.multiply(z));
            }
            Apcomplex d = ApcomplexMath.cotPrime(u, n);
            d = ApfloatHelper.limitPrecision(d, precision);
            Apcomplex result = ((n & 1L) == 0L ? g : g.negate()).subtract(ApfloatMath.pow(pi, n1).multiply(d));
            return ApfloatHelper.reducePrecision(result, extraPrecision);
        }
        Apfloat n1 = new Apfloat(n, precision, radix).add(one);
        Apcomplex result = ApfloatMath.gamma(n1).multiply(ApcomplexMath.zeta(n1, z));
        return ApfloatHelper.reducePrecision((n & 1L) == 1L ? result : result.negate(), extraPrecision);
    }

    private static Apcomplex cotPrime(Apcomplex u, long nn) {
        int n = Util.toIntExact(nn);
        int radix = u.radix();
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apcomplex[] d = new Apcomplex[n + 1];
        assert (n > 0);
        d[0] = u;
        d[1] = u.multiply(u).add(one);
        for (int i = 1; i < n; ++i) {
            int j;
            d[i + 1] = Apfloat.ZEROS[radix];
            Apint binomial = one;
            for (j = 0; j <= (i - 1) / 2; ++j) {
                d[i + 1] = d[i + 1].add(binomial.multiply(d[j]).multiply(d[i - j]).multiply(two));
                binomial = binomial.multiply(new Apint((long)(i - j), radix)).divide(new Apint((long)(j + 1), radix));
            }
            while (j <= i / 2) {
                d[i + 1] = d[i + 1].add(binomial.multiply(ApcomplexMath.pow(d[j], 2L)));
                ++j;
            }
        }
        Apcomplex result = d[n];
        return (n & 1) == 0 ? result : result.negate();
    }

    public static Apcomplex beta(Apcomplex a, Apcomplex b) throws ArithmeticException, ApfloatRuntimeException {
        boolean aOrBNonpositiveInteger;
        Apcomplex ab = a.add(b);
        boolean aNonpositiveInteger = ApcomplexMath.isNonPositiveInteger(a);
        boolean bNonpositiveInteger = ApcomplexMath.isNonPositiveInteger(b);
        boolean abNonpositiveInteger = ApcomplexMath.isNonPositiveInteger(ab);
        boolean bl = aOrBNonpositiveInteger = aNonpositiveInteger || bNonpositiveInteger;
        if (aOrBNonpositiveInteger && !abNonpositiveInteger || aNonpositiveInteger && bNonpositiveInteger) {
            throw new ApfloatArithmeticException("Beta is infinite", "beta.infinite", new Object[0]);
        }
        int radix = a.radix();
        if (!aOrBNonpositiveInteger && abNonpositiveInteger) {
            return Apcomplex.ZEROS[radix];
        }
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Math.min(a.precision(), b.precision()), extraPrecision);
        if (aOrBNonpositiveInteger && abNonpositiveInteger) {
            if (aNonpositiveInteger) {
                Apcomplex tmp = b;
                b = a;
                a = tmp;
            }
            a = ApfloatHelper.ensureGammaPrecision(a, precision);
            b = ApfloatHelper.ensurePrecision(b, precision);
            return ApfloatHelper.reducePrecision(ApcomplexMath.gamma(a).divide(ApcomplexMath.pochhammer(b, a)), extraPrecision);
        }
        a = ApfloatHelper.ensureGammaPrecision(a, precision);
        b = ApfloatHelper.ensureGammaPrecision(b, precision);
        ab = ApfloatHelper.ensureGammaPrecision(ab, precision);
        return ApfloatHelper.reducePrecision(ApcomplexMath.gamma(a).multiply(ApcomplexMath.gamma(b)).divide(ApcomplexMath.gamma(ab)), extraPrecision);
    }

    public static Apcomplex beta(Apcomplex z, Apcomplex a, Apcomplex b) throws ArithmeticException, ApfloatRuntimeException {
        if (ApcomplexMath.isNonPositiveInteger(a)) {
            throw new ApfloatArithmeticException("Incomplete beta with a nonpositive integer", "betaIncomplete.withNonpositiveInteger", new Object[0]);
        }
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Util.min(z.precision(), a.precision(), b.precision()), extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        a = ApfloatHelper.ensurePrecision(a, precision);
        Apfloat one = new Apfloat(1L, ApfloatHelper.extendPrecision(precision, 1L), radix);
        Apcomplex result = ApcomplexMath.pow(z, a).divide(a).multiply(ApcomplexMath.hypergeometric2F1(a, ApfloatHelper.ensurePrecision(one.subtract(b), precision), ApfloatHelper.ensurePrecision(a.add(one), precision), z));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex beta(Apcomplex z1, Apcomplex z2, Apcomplex a, Apcomplex b) throws ArithmeticException, ApfloatRuntimeException {
        int radix = z1.radix();
        if (z1.equals(z2)) {
            return Apint.ZEROS[radix];
        }
        if (ApcomplexMath.isNonPositiveInteger(a)) {
            throw new ApfloatArithmeticException("Generalized incomplete beta with a nonpositive integer", "betaIncompleteGeneralized.withNonpositiveInteger", new Object[0]);
        }
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Util.min(z1.precision(), z2.precision(), a.precision(), b.precision()), extraPrecision);
        z1 = ApfloatHelper.ensurePrecision(z1, precision);
        z2 = ApfloatHelper.ensurePrecision(z2, precision);
        a = ApfloatHelper.ensurePrecision(a, precision);
        Apfloat one = new Apfloat(1L, ApfloatHelper.extendPrecision(precision, 1L), radix);
        Apcomplex a1 = ApfloatHelper.ensurePrecision(a.add(one), precision);
        Apcomplex b1 = ApfloatHelper.ensurePrecision(one.subtract(b), precision);
        Apcomplex result = ApcomplexMath.pow(z2, a).multiply(ApcomplexMath.hypergeometric2F1(a, b1, a1, z2)).subtract(ApcomplexMath.pow(z1, a).multiply(ApcomplexMath.hypergeometric2F1(a, b1, a1, z1))).divide(a);
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex pochhammer(Apcomplex z, Apcomplex n) throws ArithmeticException, ApfloatRuntimeException {
        int radix = z.radix();
        long precision = Math.min(z.precision(), n.precision());
        Apint one = Apint.ONES[radix];
        if (n.isZero()) {
            return one.precision(precision);
        }
        long longPrecision = ApfloatHelper.getLongPrecision(radix);
        Apcomplex zn = ApfloatHelper.extendPrecision(z, longPrecision).add(ApfloatHelper.extendPrecision(n, longPrecision));
        if (ApcomplexMath.isNonPositiveInteger(z)) {
            if (ApcomplexMath.isNonPositiveInteger(zn)) {
                z = one.subtract(z).subtract(n);
                Apcomplex result = ApcomplexMath.pochhammer(z, n);
                Apint two = new Apint(2L, radix);
                return n.real().truncate().mod(two).signum() == 0 ? result : result.negate();
            }
            return Apint.ZEROS[radix];
        }
        if (n.isInteger() && n.real().signum() > 0 && n.real().compareTo(new Apint(precision, radix)) <= 0) {
            return ApcomplexMath.pochhammer(z, n.longValueExact());
        }
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long extendedPrecision = ApfloatHelper.extendPrecision(precision, extraPrecision);
        zn = ApfloatHelper.ensureGammaPrecision(zn, extendedPrecision);
        z = ApfloatHelper.ensureGammaPrecision(z, extendedPrecision);
        return ApfloatHelper.limitPrecision(ApcomplexMath.gamma(zn).divide(ApcomplexMath.gamma(z)), precision);
    }

    static Apcomplex pochhammer(Apcomplex z, long n) {
        Apfloat one;
        z = ApfloatHelper.extendPrecision(z);
        long precision = z.precision();
        Apcomplex p = one = Apcomplex.ONES[z.radix()].precision(precision);
        int k = 0;
        while ((long)k < n) {
            p = ApfloatHelper.ensurePrecision(p.multiply(z), precision);
            z = ApfloatHelper.ensurePrecision(z.add(one), precision);
            ++k;
        }
        return ApfloatHelper.reducePrecision(p);
    }

    public static Apcomplex binomial(Apcomplex n, Apcomplex k) throws ArithmeticException, ApfloatRuntimeException {
        long precision = Math.min(n.precision(), k.precision());
        int radix = n.radix();
        Apint threshold = new Apint(precision, radix);
        if (n.isInteger() && k.isInteger() && n.real().compareTo(threshold) <= 0 && k.real().compareTo(threshold) <= 0) {
            return ApintMath.binomial(n.real().truncate(), k.real().truncate()).precision(precision);
        }
        Apcomplex nk = n.subtract(k);
        if (k.isInteger() && k.real().signum() < 0 || nk.isInteger() && nk.real().signum() < 0) {
            return Apcomplex.ZEROS[radix];
        }
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        precision = ApfloatHelper.extendPrecision(precision, extraPrecision);
        Apint one = Apint.ONES[radix];
        Apcomplex n1 = ApfloatHelper.ensureGammaPrecision(n.add(one), precision);
        Apcomplex k1 = ApfloatHelper.ensureGammaPrecision(k.add(one), precision);
        Apcomplex nk1 = ApfloatHelper.ensureGammaPrecision(nk.add(one), precision);
        Apcomplex result = ApcomplexMath.gamma(n1).divide(ApcomplexMath.gamma(k1).multiply(ApcomplexMath.gamma(nk1)));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex zeta(Apcomplex s) throws ArithmeticException, ApfloatRuntimeException {
        return ZetaHelper.zeta(s);
    }

    public static Apcomplex zeta(Apcomplex s, Apcomplex a) throws ArithmeticException, ApfloatRuntimeException {
        return HurwitzZetaHelper.zeta(s, a);
    }

    public static Apcomplex hypergeometric0F1(Apcomplex a, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return HypergeometricHelper.hypergeometricPFQ(new Apcomplex[0], new Apcomplex[]{a}, z);
    }

    public static Apcomplex hypergeometric0F1Regularized(Apcomplex a, Apcomplex z) throws ApfloatRuntimeException {
        return HypergeometricHelper.hypergeometricPFQRegularized(new Apcomplex[0], new Apcomplex[]{a}, z);
    }

    public static Apcomplex hypergeometric1F1(Apcomplex a, Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return HypergeometricHelper.hypergeometricPFQ(new Apcomplex[]{a}, new Apcomplex[]{b}, z);
    }

    public static Apcomplex hypergeometric1F1Regularized(Apcomplex a, Apcomplex b, Apcomplex z) throws ApfloatRuntimeException {
        return HypergeometricHelper.hypergeometricPFQRegularized(new Apcomplex[]{a}, new Apcomplex[]{b}, z);
    }

    public static Apcomplex hypergeometric2F1(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return HypergeometricHelper.hypergeometricPFQ(new Apcomplex[]{a, b}, new Apcomplex[]{c}, z);
    }

    public static Apcomplex hypergeometric2F1Regularized(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) throws ApfloatRuntimeException {
        return HypergeometricHelper.hypergeometricPFQRegularized(new Apcomplex[]{a, b}, new Apcomplex[]{c}, z);
    }

    public static Apcomplex hypergeometricU(Apcomplex a, Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return HypergeometricHelper.hypergeometricU(a, b, z, false);
    }

    public static Apcomplex erf(Apcomplex z) throws ApfloatRuntimeException {
        if (z.isZero()) {
            return z;
        }
        if (z.scale() > 0L) {
            int radix = z.radix();
            long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
            long precision = ApfloatHelper.extendPrecision(z.precision(), extraPrecision);
            z = ApfloatHelper.ensurePrecision(z, precision);
            Apint one = Apint.ONES[radix];
            Apint two = new Apint(2L, radix);
            Apfloat sqrtPi = ApfloatMath.sqrt(ApfloatMath.pi(precision, radix));
            Apfloat half = new Aprational(one, two).precision(precision);
            Apcomplex result = one.subtract(ApcomplexMath.gamma(half, z.multiply(z)).divide(sqrtPi));
            boolean negate = z.real().signum() == 0 ? z.imag().signum() < 0 : z.real().signum() < 0;
            return ApfloatHelper.reducePrecision(negate ? result.negate() : result, extraPrecision);
        }
        return ApcomplexMath.erfFixedPrecision(z);
    }

    static Apcomplex erfFixedPrecision(Apcomplex z) throws ApfloatRuntimeException {
        if (z.isZero()) {
            return z;
        }
        int radix = z.radix();
        long targetPrecision = z.precision();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(HypergeometricHelper.ensureHypergeometricPrecision(z.multiply(z), targetPrecision), extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apint three = new Apint(3L, radix);
        Apfloat sqrtPi = ApfloatMath.sqrt(ApfloatMath.pi(precision, radix));
        Apfloat half = new Aprational(one, two).precision(precision);
        Apfloat threeHalfs = new Aprational(three, two).precision(precision);
        Apcomplex result = two.multiply(z).divide(sqrtPi).multiply(ApcomplexMath.hypergeometric1F1(half, threeHalfs, z.multiply(z).negate()));
        return ApfloatHelper.limitPrecision(result, targetPrecision);
    }

    public static Apcomplex erfc(Apcomplex z) throws ApfloatRuntimeException {
        int radix = z.radix();
        Apint one = Apint.ONES[radix];
        if (z.scale() > 0L && z.real().signum() > 0) {
            long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
            long precision = ApfloatHelper.extendPrecision(z.precision(), extraPrecision);
            z = ApfloatHelper.ensurePrecision(z, precision);
            Apfloat sqrtPi = ApfloatMath.sqrt(ApfloatMath.pi(precision, radix));
            Apfloat two = new Apfloat(2L, precision, radix);
            Apfloat half = one.divide(two);
            Apcomplex result = ApcomplexMath.gamma(half, z.multiply(z)).divide(sqrtPi);
            return ApfloatHelper.reducePrecision(result, extraPrecision);
        }
        return one.subtract(ApcomplexMath.erf(z));
    }

    static Apcomplex erfcFixedPrecision(Apcomplex z) throws ApfloatRuntimeException {
        if (z.scale() > 0L && z.real().signum() > 0 && z.real().scale() >= z.imag().scale()) {
            return ApcomplexMath.erfc(z);
        }
        Apint one = Apint.ONES[z.radix()];
        return one.subtract(ApcomplexMath.erfFixedPrecision(z));
    }

    public static Apcomplex erfi(Apcomplex z) throws ApfloatRuntimeException {
        int radix = z.radix();
        Apcomplex i = new Apcomplex(Apfloat.ZEROS[radix], Apfloat.ONES[radix]);
        return i.multiply(ApcomplexMath.erf(i.multiply(z))).negate();
    }

    static Apcomplex erfiFixedPrecision(Apcomplex z) throws ApfloatRuntimeException {
        int radix = z.radix();
        Apcomplex i = new Apcomplex(Apfloat.ZEROS[radix], Apfloat.ONES[radix]);
        return i.multiply(ApcomplexMath.erfFixedPrecision(i.multiply(z))).negate();
    }

    public static Apcomplex fresnelS(Apcomplex z) throws ApfloatRuntimeException {
        if (z.isZero()) {
            return z;
        }
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(z.precision(), extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apfloat two = new Apfloat(2L, precision, radix);
        Apfloat pi = ApfloatMath.pi(precision, radix);
        if (z.scale() > 0L) {
            Apint one = Apfloat.ONES[radix];
            Apfloat half = one.divide(two);
            Apfloat invSqrtPi = ApfloatMath.inverseRoot(pi, 2L);
            Apcomplex i = new Apcomplex(Apfloat.ZEROS[radix], one);
            Apcomplex z2 = z.multiply(z);
            Apcomplex iz2 = i.multiply(z2);
            Apcomplex iHalfPiZ2 = iz2.multiply(pi).divide(two);
            Apcomplex result = i.multiply(z).multiply(ApcomplexMath.inverseRoot(two, 2L)).divide(two).multiply(ApcomplexMath.fresnelTerm(one, half, invSqrtPi, iz2, iHalfPiZ2).subtract(ApcomplexMath.fresnelTerm(one, half, invSqrtPi, iz2.negate(), iHalfPiZ2.negate())));
            return ApfloatHelper.reducePrecision(result, extraPrecision);
        }
        Apfloat three = new Apfloat(3L, precision, radix);
        Apfloat four = new Apfloat(4L, precision, radix);
        Apfloat six = new Apfloat(6L, precision, radix);
        Apfloat seven = new Apfloat(7L, precision, radix);
        Apfloat sixteen = new Apfloat(16L, precision, radix);
        Apcomplex[] a = new Apcomplex[]{three.divide(four)};
        Apcomplex[] b = new Apcomplex[]{three.divide(two), seven.divide(four)};
        Apcomplex result = pi.multiply(ApcomplexMath.pow(z, 3L)).divide(six).multiply(HypergeometricHelper.hypergeometricPFQ(a, b, pi.multiply(pi).negate().multiply(ApcomplexMath.pow(z, 4L)).divide(sixteen)));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex fresnelC(Apcomplex z) throws ApfloatRuntimeException {
        if (z.isZero()) {
            return z;
        }
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(z.precision(), extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apfloat two = new Apfloat(2L, precision, radix);
        Apfloat pi = ApfloatMath.pi(precision, radix);
        Apint one = Apfloat.ONES[radix];
        if (z.scale() > 0L) {
            Apfloat half = one.divide(two);
            Apfloat invSqrtPi = ApfloatMath.inverseRoot(pi, 2L);
            Apcomplex i = new Apcomplex(Apfloat.ZEROS[radix], one);
            Apcomplex z2 = z.multiply(z);
            Apcomplex iz2 = i.multiply(z2);
            Apcomplex iHalfPiZ2 = iz2.multiply(pi).divide(two);
            Apcomplex result = z.multiply(ApcomplexMath.inverseRoot(two, 2L)).divide(two).multiply(ApcomplexMath.fresnelTerm(one, half, invSqrtPi, iz2, iHalfPiZ2).add(ApcomplexMath.fresnelTerm(one, half, invSqrtPi, iz2.negate(), iHalfPiZ2.negate())));
            return ApfloatHelper.reducePrecision(result, extraPrecision);
        }
        Apfloat four = new Apfloat(4L, precision, radix);
        Apfloat five = new Apfloat(5L, precision, radix);
        Apfloat sixteen = new Apfloat(16L, precision, radix);
        Apcomplex[] a = new Apcomplex[]{one.divide(four)};
        Apcomplex[] b = new Apcomplex[]{one.divide(two), five.divide(four)};
        Apcomplex result = z.multiply(HypergeometricHelper.hypergeometricPFQ(a, b, pi.multiply(pi).negate().multiply(ApcomplexMath.pow(z, 4L)).divide(sixteen)));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    private static Apcomplex fresnelTerm(Apint one, Apfloat half, Apfloat invSqrtPi, Apcomplex iz2, Apcomplex iHalfPiZ2) throws ApfloatRuntimeException {
        return ApcomplexMath.inverseRoot(iz2, 2L).multiply(one.subtract(invSqrtPi.multiply(ApcomplexMath.gamma(half, iHalfPiZ2))));
    }

    public static Apcomplex expIntegralE(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        int radix = \u03bd.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Math.min(\u03bd.precision(), z.precision()), extraPrecision);
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apfloat one = Apint.ONES[radix].precision(ApfloatHelper.extendPrecision(precision, 1L));
        Apcomplex \u03bd1 = ApfloatHelper.ensureGammaPrecision(\u03bd.subtract(one), precision);
        Apcomplex result = ApcomplexMath.pow(z, \u03bd1).multiply(ApcomplexMath.gamma(\u03bd1.negate(), z));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex expIntegralEi(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat adjust;
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(z.precision(), extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint zero = Apint.ZEROS[radix];
        if (z.imag().signum() == 0) {
            adjust = z.real().signum() > 0 ? ApfloatMath.pi(precision, radix).negate() : zero;
        } else {
            Apfloat pi = ApfloatMath.pi(precision, radix);
            adjust = z.imag().signum() < 0 ? pi.negate() : pi;
        }
        Apcomplex result = ApcomplexMath.gamma(zero, z.negate()).negate().add(new Apcomplex(zero, adjust));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex logIntegral(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        if (z.isZero()) {
            return z;
        }
        return ApcomplexMath.expIntegralEi(ApcomplexMath.log(z));
    }

    public static Apcomplex sinIntegral(Apcomplex z) throws ApfloatRuntimeException {
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(z.precision(), extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint zero = Apint.ZEROS[radix];
        Apint one = Apint.ONES[radix];
        Apfloat two = new Apfloat(2L, precision, radix);
        if (z.scale() > 0L) {
            Apfloat adjust = ApfloatMath.pi(precision, radix);
            if (z.real().signum() > 0 || z.real().signum() == 0 && z.imag().signum() > 0) {
                adjust = adjust.negate();
            }
            Apcomplex i = new Apcomplex(zero, one);
            Apcomplex iz = i.multiply(z);
            Apcomplex result = ApcomplexMath.gamma(zero, iz.negate()).subtract(ApcomplexMath.gamma(zero, iz)).add(new Apcomplex(zero, adjust)).multiply(i).divide(two);
            return ApfloatHelper.reducePrecision(result, extraPrecision);
        }
        Apfloat three = new Apfloat(3L, precision, radix);
        Apfloat four = new Apfloat(4L, precision, radix);
        Apcomplex[] a = new Apcomplex[]{one.divide(two)};
        Apcomplex[] b = new Apcomplex[]{three.divide(two), three.divide(two)};
        Apcomplex result = z.multiply(HypergeometricHelper.hypergeometricPFQ(a, b, z.multiply(z).divide(four).negate()));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex cosIntegral(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(z.precision(), extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint zero = Apint.ZEROS[radix];
        Apint one = Apint.ONES[radix];
        Apfloat two = new Apfloat(2L, precision, radix);
        if (z.scale() > 0L) {
            Apfloat adjust = zero;
            if (z.real().signum() < 0 || z.real().signum() == 0 && z.imag().signum() < 0) {
                adjust = ApfloatMath.pi(precision, radix);
                adjust = z.imag().signum() < 0 ? adjust.negate() : adjust;
            }
            Apcomplex i = new Apcomplex(zero, one);
            Apcomplex iz = i.multiply(z);
            Apcomplex result = ApcomplexMath.gamma(zero, iz.negate()).add(ApcomplexMath.gamma(zero, iz)).divide(two).negate().add(new Apcomplex(zero, adjust));
            return ApfloatHelper.reducePrecision(result, extraPrecision);
        }
        Apcomplex logz = ApcomplexMath.log(z);
        Apfloat three = new Apfloat(3L, precision, radix);
        Apfloat four = new Apfloat(4L, precision, radix);
        Apfloat euler = ApfloatMath.euler(precision, radix);
        Apcomplex[] a = new Apcomplex[]{one, one};
        Apcomplex[] b = new Apcomplex[]{two, two, three.divide(two)};
        Apcomplex z24 = z.multiply(z).divide(four).negate();
        Apcomplex result = z24.multiply(HypergeometricHelper.hypergeometricPFQ(a, b, z24)).add(logz).add(euler);
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex sinhIntegral(Apcomplex z) throws ApfloatRuntimeException {
        int radix = z.radix();
        Apcomplex i = new Apcomplex(Apint.ZEROS[radix], Apint.ONES[radix]);
        return i.multiply(ApcomplexMath.sinIntegral(i.multiply(z))).negate();
    }

    public static Apcomplex coshIntegral(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        int radix = z.radix();
        long precision = z.precision();
        Apint zero = Apint.ZEROS[radix];
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apcomplex i = new Apcomplex(zero, one);
        Apcomplex ci = ApcomplexMath.cosIntegral(i.multiply(z));
        Apfloat adjust = ApfloatMath.pi(precision, radix).divide(two).negate();
        if (z.real().signum() < 0 && z.imag().signum() >= 0) {
            Apint three = new Apint(3L, radix);
            adjust = adjust.multiply(three).negate();
        }
        return ci.add(new Apcomplex(zero, adjust));
    }

    public static Apcomplex airyAi(Apcomplex z) throws ApfloatRuntimeException {
        return ApcomplexMath.airyAi(z, z.precision());
    }

    static Apcomplex airyAi(Apcomplex z0, long targetPrecision) throws ApfloatRuntimeException {
        int radix = z0.radix();
        Apcomplex result = ApcomplexMath.airy(precision -> {
            Apfloat one = Apint.ONES[radix].precision((long)precision);
            Apfloat two = new Apfloat(2L, (long)precision, radix);
            Apfloat three = new Apfloat(3L, (long)precision, radix);
            Apfloat four = new Apfloat(4L, (long)precision, radix);
            Apfloat nine = new Apfloat(9L, (long)precision, radix);
            Apfloat twoThirds = two.divide(three);
            Apfloat invCube3 = ApfloatMath.inverseRoot(three, 3L);
            Apcomplex z = ApfloatHelper.ensurePrecision(z0, (long)precision);
            Apcomplex z39 = ApcomplexMath.pow(z, 3L).divide(nine);
            return invCube3.multiply(invCube3).divide(ApcomplexMath.gamma(twoThirds)).multiply(ApcomplexMath.hypergeometric0F1(twoThirds, z39)).subtract(z.multiply(invCube3).divide(ApcomplexMath.gamma(one.divide(three))).multiply(ApcomplexMath.hypergeometric0F1(four.divide(three), z39)));
        }, targetPrecision, radix);
        return result;
    }

    public static Apcomplex airyAiPrime(Apcomplex z) throws ApfloatRuntimeException {
        return ApcomplexMath.airyAiPrime(z, z.precision());
    }

    static Apcomplex airyAiPrime(Apcomplex z0, long targetPrecision) throws ApfloatRuntimeException {
        int radix = z0.radix();
        Apcomplex result = ApcomplexMath.airy(precision -> {
            Apfloat one = Apint.ONES[radix].precision((long)precision);
            Apfloat two = new Apfloat(2L, (long)precision, radix);
            Apfloat three = new Apfloat(3L, (long)precision, radix);
            Apfloat five = new Apfloat(5L, (long)precision, radix);
            Apfloat nine = new Apfloat(9L, (long)precision, radix);
            Apfloat oneThird = one.divide(three);
            Apfloat invCube3 = ApfloatMath.inverseRoot(three, 3L);
            Apcomplex z = ApfloatHelper.ensurePrecision(z0, (long)precision);
            Apcomplex z39 = ApcomplexMath.pow(z, 3L).divide(nine);
            return z.multiply(z).divide(two).multiply(invCube3).multiply(invCube3).divide(ApcomplexMath.gamma(two.divide(three))).multiply(ApcomplexMath.hypergeometric0F1(five.divide(three), z39)).subtract(invCube3.divide(ApcomplexMath.gamma(oneThird)).multiply(ApcomplexMath.hypergeometric0F1(oneThird, z39)));
        }, targetPrecision, radix);
        return result;
    }

    public static Apcomplex airyBi(Apcomplex z) throws ApfloatRuntimeException {
        return ApcomplexMath.airyBi(z, z.precision());
    }

    static Apcomplex airyBi(Apcomplex z0, long targetPrecision) throws ApfloatRuntimeException {
        int radix = z0.radix();
        Apcomplex result = ApcomplexMath.airy(precision -> {
            Apfloat one = Apint.ONES[radix].precision((long)precision);
            Apfloat two = new Apfloat(2L, (long)precision, radix);
            Apfloat three = new Apfloat(3L, (long)precision, radix);
            Apfloat four = new Apfloat(4L, (long)precision, radix);
            Apfloat nine = new Apfloat(9L, (long)precision, radix);
            Apfloat twoThirds = two.divide(three);
            Apfloat invSixth3 = ApfloatMath.inverseRoot(three, 6L);
            Apcomplex z = ApfloatHelper.ensurePrecision(z0, (long)precision);
            Apcomplex z39 = ApcomplexMath.pow(z, 3L).divide(nine);
            return invSixth3.divide(ApcomplexMath.gamma(twoThirds)).multiply(ApcomplexMath.hypergeometric0F1(twoThirds, z39)).add(z.divide(invSixth3.multiply(ApcomplexMath.gamma(one.divide(three)))).multiply(ApcomplexMath.hypergeometric0F1(four.divide(three), z39)));
        }, targetPrecision, radix);
        return result;
    }

    public static Apcomplex airyBiPrime(Apcomplex z) throws ApfloatRuntimeException {
        return ApcomplexMath.airyBiPrime(z, z.precision());
    }

    static Apcomplex airyBiPrime(Apcomplex z0, long targetPrecision) throws ApfloatRuntimeException {
        int radix = z0.radix();
        Apcomplex result = ApcomplexMath.airy(precision -> {
            Apfloat one = Apint.ONES[radix].precision((long)precision);
            Apfloat two = new Apfloat(2L, (long)precision, radix);
            Apfloat three = new Apfloat(3L, (long)precision, radix);
            Apfloat five = new Apfloat(5L, (long)precision, radix);
            Apfloat nine = new Apfloat(9L, (long)precision, radix);
            Apfloat oneThird = one.divide(three);
            Apfloat invSixth3 = ApfloatMath.inverseRoot(three, 6L);
            Apcomplex z = ApfloatHelper.ensurePrecision(z0, (long)precision);
            Apcomplex z39 = ApcomplexMath.pow(z, 3L).divide(nine);
            return ApcomplexMath.inverseRoot(invSixth3.multiply(ApcomplexMath.gamma(oneThird)), 1L).multiply(ApcomplexMath.hypergeometric0F1(oneThird, z39)).add(z.multiply(z).divide(two).multiply(invSixth3).divide(ApcomplexMath.gamma(two.divide(three))).multiply(ApcomplexMath.hypergeometric0F1(five.divide(three), z39)));
        }, targetPrecision, radix);
        return result;
    }

    private static Apcomplex airy(Function<Long, Apcomplex> f, long targetPrecision, int radix) {
        Apcomplex result;
        long precisionLoss;
        long resultPrecision;
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = resultPrecision = ApfloatHelper.extendPrecision(targetPrecision, extraPrecision);
        do {
            precisionLoss = (result = f.apply(precision)).isZero() ? precision : resultPrecision - result.precision();
            precision = Util.ifFinite(precision, precision + precisionLoss);
        } while (precisionLoss > 0L);
        long reducePrecision = Math.max(0L, Math.round(Math.log(result.scale()) / Math.log(radix)));
        targetPrecision = ApfloatHelper.reducePrecision(targetPrecision, reducePrecision);
        return ApfloatHelper.limitPrecision(result, targetPrecision);
    }

    public static Apcomplex besselJ(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return BesselHelper.besselJ(\u03bd, z);
    }

    public static Apcomplex besselI(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return BesselHelper.besselI(\u03bd, z);
    }

    public static Apcomplex besselY(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return BesselHelper.besselY(\u03bd, z);
    }

    public static Apcomplex besselK(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return BesselHelper.besselK(\u03bd, z);
    }

    public static Apcomplex struveH(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.struve(\u03bd, z, true);
    }

    public static Apcomplex struveL(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.struve(\u03bd, z, false);
    }

    private static Apcomplex struve(Apcomplex \u03bd, Apcomplex z, boolean negate) throws ArithmeticException, ApfloatRuntimeException {
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Math.min(\u03bd.precision(), z.precision()), extraPrecision);
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apfloat one = Apint.ONES[radix].precision(precision);
        Apfloat two = new Apfloat(2L, precision, radix);
        Apfloat three = new Apfloat(3L, precision, radix);
        Apfloat oneAndHalf = three.divide(two);
        Apcomplex[] a = new Apcomplex[]{one};
        Apcomplex[] b = new Apcomplex[]{oneAndHalf, \u03bd.add(oneAndHalf)};
        Apcomplex z2 = z.divide(two);
        Apcomplex z24 = ApcomplexMath.pow(z2, 2L);
        if (negate) {
            z24 = z24.negate();
        }
        Apcomplex result = ApcomplexMath.pow(z2, \u03bd.add(one)).multiply(HypergeometricHelper.hypergeometricPFQRegularized(a, b, z24));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex angerJ(Apcomplex \u03bd, Apcomplex z) throws ApfloatRuntimeException {
        return ApcomplexMath.angerWeber(\u03bd, z, false);
    }

    public static Apcomplex weberE(Apcomplex \u03bd, Apcomplex z) throws ApfloatRuntimeException {
        return ApcomplexMath.angerWeber(\u03bd, z, true);
    }

    private static Apcomplex angerWeber(Apcomplex \u03bd, Apcomplex z, boolean weber) throws ApfloatRuntimeException {
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Math.min(\u03bd.precision(), z.precision()), extraPrecision);
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apfloat one = Apint.ONES[radix].precision(precision);
        Apfloat two = new Apfloat(2L, precision, radix);
        Apfloat three = new Apfloat(3L, precision, radix);
        Apfloat oneAndHalf = three.divide(two);
        Apcomplex \u03bd2 = \u03bd.divide(two);
        Apcomplex \u03c0\u03bd2 = ApfloatMath.pi(precision, radix).multiply(\u03bd2);
        Apcomplex z2 = z.divide(two);
        Apcomplex z24 = ApcomplexMath.pow(z2, 2L).negate();
        Apcomplex f1 = weber ? one : z2;
        Apcomplex f2 = weber ? z2 : one;
        Apcomplex[] a = new Apcomplex[]{one};
        Apcomplex[] b1 = new Apcomplex[]{oneAndHalf.subtract(\u03bd2), oneAndHalf.add(\u03bd2)};
        Apcomplex[] b2 = new Apcomplex[]{one.subtract(\u03bd2), one.add(\u03bd2)};
        if (weber) {
            Apcomplex[] tmp = b1;
            b1 = b2;
            b2 = tmp;
        }
        Apcomplex t1 = f1.multiply(ApcomplexMath.sin(\u03c0\u03bd2)).multiply(HypergeometricHelper.hypergeometricPFQRegularized(a, b1, z24));
        Apcomplex t2 = f2.multiply(ApcomplexMath.cos(\u03c0\u03bd2)).multiply(HypergeometricHelper.hypergeometricPFQRegularized(a, b2, z24));
        Apcomplex result = weber ? t1.subtract(t2) : t1.add(t2);
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex ellipticK(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.ellipticK(z, z.precision());
    }

    static Apcomplex ellipticK(Apcomplex z, long precision) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.ellipticK(z, precision, null);
    }

    static Apcomplex ellipticK(Apcomplex z, long precision, Consumer<Apcomplex> consumer) throws ArithmeticException, ApfloatRuntimeException {
        int radix = z.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        precision = ApfloatHelper.extendPrecision(precision, extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint one = Apint.ONES[radix];
        Apfloat two = new Apfloat(2L, precision, radix);
        Apfloat pi = ApfloatMath.pi(precision, radix);
        Apcomplex result = pi.divide(two.multiply(ApcomplexMath.agm(one, ApcomplexMath.sqrt(ApfloatHelper.ensurePrecision(one.subtract(z), precision)), consumer)));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex ellipticE(Apcomplex z) throws ApfloatRuntimeException {
        return ApcomplexMath.ellipticE(z, z.precision());
    }

    static Apcomplex ellipticE(Apcomplex z, long precision) throws ApfloatRuntimeException {
        int radix = z.radix();
        Apint zero = Apint.ZEROS[radix];
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        if (z.equals(one)) {
            return z;
        }
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        precision = ApfloatHelper.extendPrecision(precision, extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apcomplex[] sum = new Apcomplex[]{zero};
        Aprational[] p2 = new Aprational[1];
        Apcomplex k = ApcomplexMath.ellipticK(z, precision, c2 -> {
            p2[0] = p2[0] == null ? new Aprational(one, two) : p2[0].multiply(two);
            sum[0] = sum[0].add(p2[0].multiply((Apcomplex)c2));
        });
        Apcomplex result = one.subtract(sum[0]).multiply(k);
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex hermiteH(Apcomplex \u03bd, Apcomplex z) throws ApfloatRuntimeException {
        Apcomplex result;
        Apfloat two;
        long precisionLoss;
        long resultPrecision;
        int radix = z.radix();
        long targetPrecision = Math.min(\u03bd.precision(), z.precision());
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = resultPrecision = ApfloatHelper.extendPrecision(targetPrecision, extraPrecision);
        Apint one = Apint.ONES[radix];
        if (\u03bd.isZero()) {
            return one.precision(targetPrecision);
        }
        if (z.isZero()) {
            Apint two2 = new Apint(2L, radix);
            if (\u03bd.isInteger() && \u03bd.real().signum() > 0 && \u03bd.real().truncate().mod(two2).signum() > 0) {
                return Apint.ZEROS[radix];
            }
            \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
            Apfloat pi = ApfloatMath.pi(precision, radix);
            Apcomplex \u03bd12 = ApfloatHelper.ensureGammaPrecision(ApfloatHelper.ensurePrecision(one.subtract(\u03bd), precision).divide(two2), precision);
            Apcomplex result2 = ApcomplexMath.pow((Apcomplex)two2.precision(precision), \u03bd).multiply(ApcomplexMath.sqrt(pi)).divide(ApcomplexMath.gamma(\u03bd12));
            return ApfloatHelper.reducePrecision(result2, extraPrecision);
        }
        do {
            \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
            z = ApfloatHelper.ensurePrecision(z, precision);
            two = new Apfloat(2L, precision, radix);
            Apfloat three = new Apfloat(3L, precision, radix);
            Apcomplex n12 = one.subtract(\u03bd).divide(two);
            Apcomplex nn2 = \u03bd.negate().divide(two);
            Apcomplex z2 = z.multiply(z);
            result = Apint.ZEROS[radix];
            if (!ApcomplexMath.isNonPositiveInteger(n12)) {
                result = ApcomplexMath.inverseRoot(ApcomplexMath.gamma(ApfloatHelper.ensureGammaPrecision(n12, precision)), 1L).multiply(ApcomplexMath.hypergeometric1F1(ApfloatHelper.ensurePrecision(nn2, precision), one.divide(two), z2));
            }
            if (!ApcomplexMath.isNonPositiveInteger(nn2)) {
                result = result.subtract(two.multiply(z).divide(ApcomplexMath.gamma(ApfloatHelper.ensureGammaPrecision(nn2, precision))).multiply(ApcomplexMath.hypergeometric1F1(ApfloatHelper.ensurePrecision(n12, precision), three.divide(two), z2)));
            }
            precisionLoss = result.isZero() ? precision : resultPrecision - result.precision();
            precision = Util.ifFinite(precision, precision + precisionLoss);
        } while (precisionLoss > 0L);
        precision = resultPrecision;
        two = new Apfloat(2L, precision, radix);
        Apfloat pi = ApfloatMath.pi(precision, radix);
        \u03bd = ApfloatHelper.limitPrecision(\u03bd, precision);
        result = ApcomplexMath.pow((Apcomplex)two, \u03bd).multiply(ApcomplexMath.sqrt(pi)).multiply(result);
        if (\u03bd.imag().signum() == 0 && z.imag().signum() == 0) {
            result = result.real();
        }
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex laguerreL(Apcomplex \u03bd, Apcomplex z) throws ApfloatRuntimeException {
        long precision = Math.min(\u03bd.precision(), z.precision());
        Apfloat one = Apint.ONES[\u03bd.radix()].precision(precision);
        return ApcomplexMath.hypergeometric1F1(\u03bd.negate(), one, z);
    }

    public static Apcomplex laguerreL(Apcomplex \u03bd, Apcomplex \u03bb, Apcomplex z) throws ApfloatRuntimeException {
        long precision = Util.min(\u03bd.precision(), \u03bb.precision(), z.precision());
        Apint one = Apint.ONES[\u03bd.radix()];
        Apcomplex \u03bd1 = ApfloatHelper.ensurePrecision(\u03bd.add(one), precision);
        Apcomplex \u03bb1 = ApfloatHelper.ensurePrecision(\u03bb.add(one), precision);
        return ApcomplexMath.pochhammer(\u03bd1, \u03bb).multiply(ApcomplexMath.hypergeometric1F1Regularized(\u03bd.negate(), \u03bb1, z));
    }

    public static Apcomplex legendreP(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apint zero = Apcomplex.ZEROS[\u03bd.radix()];
        return ApcomplexMath.legendreP(\u03bd, zero, z);
    }

    public static Apcomplex legendreP(Apcomplex \u03bd, Apcomplex \u03bc, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        int radix = \u03bd.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Util.min(\u03bd.precision(), \u03bc.precision(), z.precision()), extraPrecision);
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        \u03bc = ApfloatHelper.ensurePrecision(\u03bc, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apcomplex \u03bd1 = ApfloatHelper.ensurePrecision(\u03bd.add(one), precision);
        Apcomplex \u03bc1 = ApfloatHelper.ensurePrecision(one.subtract(\u03bc), precision);
        Apcomplex z12 = ApfloatHelper.ensurePrecision(one.subtract(z), precision).divide(two);
        Apcomplex result = ApcomplexMath.hypergeometric2F1Regularized(\u03bd.negate(), \u03bd1, \u03bc1, z12);
        if (!\u03bc.isZero()) {
            Apcomplex \u03bc2 = \u03bc.divide(two);
            Apcomplex z1 = ApfloatHelper.ensurePrecision(one.add(z), precision);
            Apcomplex z1n = ApfloatHelper.ensurePrecision(one.subtract(z), precision);
            result = result.multiply(ApcomplexMath.pow(z1, \u03bc2)).divide(ApcomplexMath.pow(z1n, \u03bc2));
        }
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex legendreQ(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apint zero = Apcomplex.ZEROS[\u03bd.radix()];
        return ApcomplexMath.legendreQ(\u03bd, zero, z);
    }

    public static Apcomplex legendreQ(Apcomplex \u03bd, Apcomplex \u03bc, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result;
        Apfloat two;
        long precisionLoss;
        long resultPrecision;
        int radix = \u03bd.radix();
        long targetPrecision = Util.min(\u03bd.precision(), \u03bc.precision(), z.precision());
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = resultPrecision = ApfloatHelper.extendPrecision(targetPrecision, extraPrecision);
        Apint one = Apint.ONES[radix];
        boolean isOne = z.equals(one) || z.equals(one.negate());
        do {
            Apcomplex \u03bc\u03bd;
            \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
            \u03bc = ApfloatHelper.ensurePrecision(\u03bc, precision);
            z = ApfloatHelper.ensurePrecision(z, precision);
            two = new Apfloat(2L, precision, radix);
            Apint three = new Apint(3L, radix);
            Apfloat pi = ApfloatMath.pi(precision, radix);
            Apcomplex z2 = z.multiply(z);
            Apcomplex p1 = ApcomplexMath.pochhammer(ApfloatHelper.ensurePrecision(one.subtract(\u03bc).add(\u03bd), precision).divide(two), ApfloatHelper.ensurePrecision(one.divide(two).add(\u03bc), precision));
            Apcomplex p2 = ApcomplexMath.pochhammer(ApfloatHelper.ensurePrecision(two.subtract(\u03bc).add(\u03bd), precision).divide(two), ApfloatHelper.ensurePrecision(\u03bc.subtract(one.divide(two)), precision));
            result = Apint.ZEROS[radix];
            if (!p1.isZero()) {
                \u03bc\u03bd = ApfloatHelper.ensurePrecision(\u03bc.add(\u03bd), precision);
                Apcomplex \u03bc\u03bd12 = ApfloatHelper.ensurePrecision(one.subtract(\u03bc).subtract(\u03bd), precision).divide(two);
                Apcomplex \u03bd\u03bc = ApfloatHelper.ensurePrecision(\u03bd.subtract(\u03bc), precision);
                Apcomplex \u03bd\u03bc12 = ApfloatHelper.ensurePrecision(\u03bd\u03bc.divide(two).add(one), precision);
                result = result.add(ApcomplexMath.cos(\u03bc\u03bd.divide(two).multiply(pi)).multiply(p1).multiply(z).divide(two).multiply(ApcomplexMath.hypergeometric2F1Regularized(\u03bc\u03bd12, \u03bd\u03bc12, three.divide(two), z2)));
            }
            if (!p2.isZero()) {
                \u03bc\u03bd = ApfloatHelper.ensurePrecision(\u03bc.add(\u03bd), precision);
                Apcomplex \u03bc\u03bd2 = ApfloatHelper.ensurePrecision(\u03bc.negate().subtract(\u03bd), precision).divide(two);
                Apcomplex \u03bd\u03bc12 = ApfloatHelper.ensurePrecision(\u03bd.subtract(\u03bc).add(one), precision).divide(two);
                result = result.subtract(ApcomplexMath.sin(\u03bc\u03bd.divide(two).multiply(pi)).multiply(p2).divide(two).multiply(ApcomplexMath.hypergeometric2F1Regularized(\u03bc\u03bd2, \u03bd\u03bc12, one.divide(two), z2)));
            }
            precisionLoss = !isOne && result.isZero() ? precision : resultPrecision - ((Apcomplex)result).precision();
            precision = Util.ifFinite(precision, precision + precisionLoss);
        } while (precisionLoss > 0L);
        precision = resultPrecision;
        two = new Apfloat(2L, precision, radix);
        Apfloat pi = ApfloatMath.pi(precision, radix);
        \u03bc = ApfloatHelper.limitPrecision(\u03bc, precision);
        z = ApfloatHelper.limitPrecision(z, precision);
        Apcomplex z2 = z.multiply(z);
        result = result.multiply(ApcomplexMath.pow((Apcomplex)two, \u03bc)).multiply(pi).multiply(ApcomplexMath.pow(ApfloatHelper.ensurePrecision(one.subtract(z2), precision), \u03bc.negate().divide(two)));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex sphericalHarmonicY(Apcomplex \u03bb, Apcomplex \u03bc, Apcomplex \u03d1, Apcomplex \u03d5) throws ArithmeticException, ApfloatRuntimeException {
        if (\u03bb.isInteger() && \u03bc.isInteger()) {
            return ApcomplexMath.sphericalHarmonicY(\u03bb.real().truncate(), \u03bc.real().truncate(), \u03d1, \u03d5);
        }
        int radix = \u03bb.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Util.min(\u03bb.precision(), \u03bc.precision(), \u03d1.precision(), \u03d5.precision()), extraPrecision);
        \u03bb = ApfloatHelper.ensurePrecision(\u03bb, precision);
        \u03bc = ApfloatHelper.ensurePrecision(\u03bc, precision);
        \u03d1 = ApfloatHelper.ensurePrecision(\u03d1, precision);
        \u03d5 = ApfloatHelper.ensurePrecision(\u03d5, precision);
        Apint zero = Apint.ZEROS[radix];
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apint four = new Apint(4L, radix);
        Apcomplex i = new Apcomplex(zero, one);
        Apcomplex result = two.multiply(\u03bb).add(one);
        if (result.isZero()) {
            return result;
        }
        Apfloat pi = ApfloatMath.pi(precision, radix);
        result = ApcomplexMath.sqrt(result.divide(four.multiply(pi)));
        if (!\u03bc.isZero()) {
            Apcomplex \u03bb\u03bc1 = \u03bb.add(\u03bc).add(one);
            if (\u03bb\u03bc1.isInteger() && \u03bb\u03bc1.real().signum() <= 0) {
                return zero;
            }
            Apcomplex \u03bbn\u03bc1 = ApfloatHelper.ensureGammaPrecision(\u03bb.subtract(\u03bc).add(one), precision);
            \u03bb\u03bc1 = ApfloatHelper.ensureGammaPrecision(\u03bb\u03bc1, precision);
            result = result.multiply(ApcomplexMath.sqrt(ApcomplexMath.gamma(\u03bbn\u03bc1))).divide(ApcomplexMath.sqrt(ApcomplexMath.gamma(\u03bb\u03bc1))).multiply(ApcomplexMath.exp(i.multiply(\u03d5).multiply(\u03bc)));
        }
        return ApfloatHelper.reducePrecision(result.multiply(ApcomplexMath.legendreP(\u03bb, \u03bc, ApcomplexMath.cos(\u03d1))), extraPrecision);
    }

    private static Apcomplex sphericalHarmonicY(Apint n, Apint m, Apcomplex \u03d1, Apcomplex \u03d5) throws ArithmeticException, ApfloatRuntimeException {
        int radix = n.radix();
        Apint zero = Apint.ZEROS[radix];
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apint four = new Apint(4L, radix);
        if (n.signum() < 0) {
            return ApcomplexMath.sphericalHarmonicY(n.negate().subtract(one), m, \u03d1, \u03d5);
        }
        if (n.compareTo(ApfloatMath.abs(m)) < 0) {
            return zero;
        }
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Util.min(\u03d1.precision(), \u03d5.precision()), extraPrecision);
        \u03d1 = ApfloatHelper.ensurePrecision(\u03d1, precision);
        \u03d5 = ApfloatHelper.ensurePrecision(\u03d5, precision);
        Apfloat pi = ApfloatMath.pi(precision, radix);
        Apcomplex i = new Apcomplex(zero, one);
        Apcomplex result = ApcomplexMath.sqrt(two.multiply(n).add(one).multiply(ApfloatMath.factorial(ApfloatHelper.longValueExact(n.subtract(m)), precision, radix)).divide(four.multiply(pi).multiply(ApfloatMath.factorial(ApfloatHelper.longValueExact(n.add(m)), precision, radix)))).multiply(ApcomplexMath.exp(i.multiply(m).multiply(\u03d5))).multiply(ApcomplexMath.legendreP(n, m, ApcomplexMath.cos(\u03d1)));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex chebyshevT(Apcomplex \u03bd, Apcomplex z) throws ApfloatRuntimeException {
        int radix = \u03bd.radix();
        if (\u03bd.isZero() && z.isZero()) {
            return Apcomplex.ONES[radix];
        }
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Math.min(\u03bd.precision(), z.precision()), extraPrecision);
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apcomplex result = ApcomplexMath.cos(\u03bd.multiply(ApcomplexMath.acos(z, precision)));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex chebyshevU(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        int radix = \u03bd.radix();
        Apint one = Apint.ONES[radix];
        if (\u03bd.isZero() && z.isZero()) {
            return one;
        }
        if (z.equals(one)) {
            return one.add(\u03bd);
        }
        if (z.equals(one.negate()) && \u03bd.isInteger()) {
            Apcomplex result = one.add(\u03bd);
            boolean negate = \u03bd.real().truncate().mod(new Apint(2L, radix)).signum() != 0;
            return negate ? result.negate() : result;
        }
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Math.min(\u03bd.precision(), z.precision()), extraPrecision);
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apcomplex result = ApcomplexMath.sin(\u03bd.add(one).multiply(ApcomplexMath.acos(z, precision))).multiply(ApcomplexMath.inverseRoot(one.subtract(ApcomplexMath.pow(z, 2L)), 2L));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public static Apcomplex gegenbauerC(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apint two = new Apint(2L, \u03bd.radix());
        return two.divide(\u03bd).multiply(ApcomplexMath.chebyshevT(\u03bd, z));
    }

    public static Apcomplex gegenbauerC(Apcomplex \u03bd, Apcomplex \u03bb, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result;
        if (\u03bb.isZero()) {
            return \u03bb;
        }
        if (\u03bd.isInteger() && \u03bd.real().signum() >= 0) {
            return ApcomplexMath.gegenbauerC(ApfloatHelper.longValueExact(\u03bd.real().truncate()), \u03bb, z);
        }
        int radix = \u03bd.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Util.min(\u03bd.precision(), \u03bb.precision(), z.precision()), extraPrecision);
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        \u03bb = ApfloatHelper.ensurePrecision(\u03bb, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint one = Apint.ONES[radix];
        Apfloat two = new Apfloat(2L, precision, radix);
        Apfloat pi = ApfloatMath.pi(precision, radix);
        Apcomplex \u03bb12 = ApfloatHelper.ensurePrecision(one.subtract(two.multiply(\u03bb)), precision);
        Apcomplex \u03bd\u03bb = ApfloatHelper.ensurePrecision(\u03bd.add(\u03bb), precision);
        Apcomplex \u03bd1 = ApfloatHelper.ensurePrecision(\u03bd.add(one), precision);
        Apcomplex \u03bb2\u03bd = ApfloatHelper.ensurePrecision(two.multiply(\u03bb).add(\u03bd), precision);
        Apcomplex \u03bbhalf = ApfloatHelper.ensurePrecision(\u03bb.add(one.divide(two)), precision);
        Apcomplex z12 = ApfloatHelper.ensurePrecision(one.subtract(z), precision).divide(two);
        if (ApcomplexMath.isNonPositiveInteger(\u03bd1)) {
            if (ApcomplexMath.isNonPositiveInteger(\u03bb)) {
                return Apint.ZEROS[radix];
            }
            result = ApcomplexMath.pochhammer(\u03bd1, \u03bb12.negate()).divide(ApcomplexMath.gamma(ApfloatHelper.ensureGammaPrecision(\u03bb, precision)));
        } else {
            result = ApcomplexMath.pochhammer(\u03bb, \u03bd\u03bb).divide(ApcomplexMath.gamma(ApfloatHelper.ensureGammaPrecision(\u03bd1, precision)));
        }
        if (result.isZero()) {
            return result;
        }
        result = result.multiply(ApcomplexMath.pow((Apcomplex)two, \u03bb12)).multiply(ApcomplexMath.sqrt(pi)).multiply(ApcomplexMath.hypergeometric2F1Regularized(\u03bd.negate(), \u03bb2\u03bd, \u03bbhalf, z12));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    private static Apcomplex gegenbauerC(long n, Apcomplex \u03bb, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        long n2;
        long precision = Math.min(\u03bb.precision(), z.precision());
        int radix = \u03bb.radix();
        if (n == 0L) {
            return new Apfloat(1L, precision, radix);
        }
        precision = ApfloatHelper.extendPrecision(precision);
        \u03bb = ApfloatHelper.ensurePrecision(\u03bb, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        long k = n2 = n / 2L;
        long n2k = n - 2L * k;
        Apcomplex sum = Apint.ZEROS[radix];
        Apcomplex z2 = z.multiply(new Apint(2L, radix));
        Apcomplex numerator = ApcomplexMath.pochhammer(\u03bb, n - k).multiply(n2k == 0L ? Apint.ONES[radix] : z2);
        Apcomplex denominator = ApfloatMath.factorial(k, precision, radix).multiply(ApfloatMath.factorial(n2k, precision, radix));
        z2 = z2.multiply(z2);
        while (k >= 0L) {
            if (k < n2) {
                numerator = numerator.multiply(\u03bb.add(new Apint(n - k - 1L, radix))).multiply(z2);
                denominator = denominator.multiply(new Apint(n2k - 1L, radix)).multiply(new Apint(n2k, radix));
            }
            Apcomplex term = numerator.divide(denominator);
            Apcomplex apcomplex = sum = (k & 1L) == 0L ? sum.add(term) : sum.subtract(term);
            if (k > 0L) {
                numerator = numerator.multiply(new Apint(k, radix));
            }
            --k;
            n2k += 2L;
        }
        return ApfloatHelper.reducePrecision(sum);
    }

    public static Apcomplex jacobiP(Apcomplex \u03bd, Apcomplex a, Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        if (\u03bd.isInteger() && \u03bd.real().signum() >= 0) {
            return ApcomplexMath.jacobiP(ApfloatHelper.longValueExact(\u03bd.real().truncate()), a, b, z);
        }
        int radix = \u03bd.radix();
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(Util.min(\u03bd.precision(), a.precision(), b.precision(), z.precision()), extraPrecision);
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        a = ApfloatHelper.ensurePrecision(a, precision);
        b = ApfloatHelper.ensurePrecision(b, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apcomplex \u03bd1 = ApfloatHelper.ensurePrecision(\u03bd.add(one), precision);
        Apcomplex ab\u03bd1 = ApfloatHelper.ensurePrecision(a.add(b).add(\u03bd).add(one), precision);
        Apcomplex a1 = ApfloatHelper.ensurePrecision(a.add(one), precision);
        Apcomplex z12 = ApfloatHelper.ensurePrecision(one.subtract(z), precision).divide(two);
        Apcomplex result = ApcomplexMath.pochhammer(\u03bd1, a).multiply(ApcomplexMath.hypergeometric2F1Regularized(\u03bd.negate(), ab\u03bd1, a1, z12));
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    private static Apcomplex jacobiP(long n, Apcomplex a, Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        long precision = Util.min(a.precision(), b.precision(), z.precision());
        int radix = a.radix();
        if (n == 0L) {
            return new Apfloat(1L, precision, radix);
        }
        precision = ApfloatHelper.extendPrecision(precision);
        a = ApfloatHelper.ensurePrecision(a, precision);
        b = ApfloatHelper.ensurePrecision(b, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apcomplex sum = Apint.ZEROS[radix];
        Apcomplex a1 = ApfloatHelper.ensurePrecision(a.add(one), precision);
        Apcomplex abn1 = ApfloatHelper.ensurePrecision(a1.add(b).add(new Apint(n, radix)), precision);
        Apcomplex z12 = ApfloatHelper.ensurePrecision(one.subtract(z), precision).divide(two);
        Apcomplex numerator = one;
        Apcomplex denominator = ApfloatMath.factorial(n, precision, radix);
        for (long k = 0L; k <= n; ++k) {
            Apint kk = new Apint(k, radix);
            Apcomplex term = numerator.multiply(ApcomplexMath.pochhammer(a1.add(kk), n - k)).divide(denominator);
            sum = sum.add(term);
            if (k >= n) continue;
            Apcomplex abnk1 = ApfloatHelper.ensurePrecision(abn1.add(kk), precision);
            numerator = numerator.multiply(new Apint(-n + k, radix)).multiply(abnk1).multiply(z12);
            denominator = denominator.multiply(kk.add(one));
        }
        return ApfloatHelper.reducePrecision(sum);
    }

    public static Apcomplex fibonacci(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result;
        int radix = \u03bd.radix();
        long targetPrecision = Math.min(\u03bd.precision(), z.precision());
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long precision = ApfloatHelper.extendPrecision(targetPrecision, extraPrecision);
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        Apint zero = Apfloat.ZEROS[radix];
        Apint two = new Apint(2L, radix);
        Apint four = new Apint(4L, radix);
        Apcomplex twoI = new Apcomplex(zero, two);
        if (\u03bd.isInteger() && (z.equals(twoI) || z.equals(twoI.negate()))) {
            long n = \u03bd.real().truncate().mod(four).longValueExact();
            Apcomplex i = new Apcomplex(zero, new Apint(z.imag().signum() < 0 ? -1L : 1L, radix));
            result = ApcomplexMath.pow(i, n + 1L).multiply(\u03bd).negate();
        } else {
            Apfloat pi = ApfloatMath.pi(precision, radix);
            Apcomplex \u03bd2 = ApcomplexMath.pow((Apcomplex)two, \u03bd);
            Apcomplex z4 = ApcomplexMath.sqrt(ApfloatHelper.ensurePrecision(z.multiply(z).add(four), precision));
            Apcomplex zz4\u03bd = ApcomplexMath.pow(ApfloatHelper.ensurePrecision(z.add(z4), precision), \u03bd);
            result = zz4\u03bd.divide(\u03bd2).subtract(ApcomplexMath.cos(pi.multiply(\u03bd)).multiply(\u03bd2).divide(zz4\u03bd)).divide(z4);
        }
        targetPrecision = ApfloatHelper.reducePrecision(targetPrecision, Math.max(0L, (long)Math.log((double)result.scale() * 0.3)));
        return ApfloatHelper.limitPrecision(result, targetPrecision);
    }

    public static Apcomplex eulerE(long n, Apcomplex z) throws IllegalArgumentException, ApfloatRuntimeException {
        return ApcomplexMath.eulerE(n, z, z.precision());
    }

    static Apcomplex eulerE(long n, Apcomplex z, long precision) throws IllegalArgumentException, ApfloatRuntimeException {
        if (n < 0L) {
            throw new IllegalArgumentException("Negative Euler polynomial");
        }
        int radix = z.radix();
        long n1 = Util.addExact(n, 1L);
        if (z.isZero()) {
            if (n > 0L && (n & 1L) == 0L) {
                return z;
            }
            if (precision == Long.MAX_VALUE) {
                Apint one = Apint.ONES[radix];
                Apint two = new Apint(2L, radix);
                return AprationalMath.bernoulli(n1, radix).multiply(two).multiply(ApintMath.pow(two, n1).subtract(one)).divide(new Apint(n1, radix)).negate();
            }
        }
        if (n == 0L) {
            return new Apfloat(1L, precision, radix);
        }
        long extraPrecision = (long)Math.ceil(2.7 * (double)n / Math.log(radix));
        long workingPrecision = ApfloatHelper.extendPrecision(precision, extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, workingPrecision);
        Apfloat two = new Apfloat(2L, workingPrecision, radix);
        Apfloat nn = new Apfloat(-n, workingPrecision, radix);
        Apcomplex result = two.multiply(ApcomplexMath.pow((Apcomplex)two, n1).multiply(ApcomplexMath.zeta(nn, z.divide(two))).subtract(ApcomplexMath.zeta(nn, z)));
        return ApfloatHelper.limitPrecision(result, precision);
    }

    public static Apcomplex bernoulliB(long n, Apcomplex z) throws IllegalArgumentException, ApfloatRuntimeException {
        return ApcomplexMath.bernoulliB(n, z, z.precision());
    }

    static Apcomplex bernoulliB(long n, Apcomplex z, long precision) throws IllegalArgumentException, ApfloatRuntimeException {
        if (n < 0L) {
            throw new IllegalArgumentException("Negative Bernoulli polynomial");
        }
        int radix = z.radix();
        if (z.isZero()) {
            if (n > 1L && (n & 1L) == 1L) {
                return z;
            }
            if (precision == Long.MAX_VALUE) {
                return AprationalMath.bernoulli(n, radix);
            }
        }
        if (n == 0L) {
            return new Apfloat(1L, precision, radix);
        }
        long extraPrecision = (long)Math.ceil(2.7 * (double)n / Math.log(radix));
        long workingPrecision = ApfloatHelper.extendPrecision(precision, extraPrecision);
        z = ApfloatHelper.ensurePrecision(z, workingPrecision);
        Apfloat nn = new Apfloat(-n, workingPrecision, radix);
        Apfloat n1 = new Apfloat(1L - n, workingPrecision, radix);
        Apcomplex result = nn.multiply(ApcomplexMath.zeta(n1, z));
        return ApfloatHelper.limitPrecision(result, precision);
    }

    public static Apcomplex harmonicNumber(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        if (z.isZero()) {
            return z;
        }
        long precision = z.precision();
        int radix = z.radix();
        Apint one = Apint.ONES[radix];
        Apfloat eulerGamma = ApfloatMath.euler(precision, radix);
        Apcomplex z1 = ApfloatHelper.ensurePrecision(z.add(one), precision);
        return ApcomplexMath.digamma(z1).add(eulerGamma);
    }

    public static Apcomplex harmonicNumber(Apcomplex z, Apcomplex r) throws ArithmeticException, ApfloatRuntimeException {
        if (z.isZero() || r.isZero()) {
            return z;
        }
        int radix = z.radix();
        Apint one = Apint.ONES[radix];
        if (r.equals(one)) {
            return ApcomplexMath.harmonicNumber(z);
        }
        long precision = Math.min(z.precision(), r.precision());
        Apcomplex z1 = ApfloatHelper.ensurePrecision(z.add(one), precision);
        return ApcomplexMath.zeta(r).subtract(ApcomplexMath.zeta(r, z1));
    }

    public static Apcomplex polylog(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apint \u03bdRounded;
        long digitLoss;
        if (z.isZero()) {
            return z;
        }
        int radix = \u03bd.radix();
        long targetPrecision = Math.min(\u03bd.precision(), z.precision());
        long extraPrecision = (long)Math.ceil(Math.max((double)ApfloatHelper.getSmallExtraPrecision(radix), 2.7 * (double)ApfloatHelper.longValueExact(\u03bd.real().ceil()) / Math.log(radix)));
        long precision = ApfloatHelper.extendPrecision(targetPrecision, extraPrecision);
        Apint zero = Apint.ZEROS[radix];
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        if (z.equals(one) && \u03bd.real().compareTo(one) <= 0) {
            throw new ApfloatArithmeticException("Polylogarithm is infinite", "polylog.infinite", new Object[0]);
        }
        if (\u03bd.isInteger() && \u03bd.real().signum() > 0) {
            \u03bd = \u03bd.precision(Long.MAX_VALUE).add(ApcomplexMath.scale(new Apfloat("0.1", precision, radix), -precision));
            precision = Util.ifFinite(precision, precision + precision);
        } else if (\u03bd.real().signum() > 0 && (digitLoss = Math.min(precision, -\u03bd.subtract(\u03bdRounded = RoundingHelper.roundToInteger(\u03bd.real(), RoundingMode.HALF_EVEN).truncate()).scale())) > 0L) {
            precision = Util.ifFinite(precision, precision + digitLoss);
        }
        \u03bd = ApfloatHelper.ensurePrecision(\u03bd, precision);
        z = ApfloatHelper.ensurePrecision(z, precision);
        if (\u03bd.isZero()) {
            Apcomplex z1 = ApfloatHelper.ensurePrecision(one.subtract(z), precision);
            return ApfloatHelper.limitPrecision(z.divide(z1), targetPrecision);
        }
        Apfloat pi = ApfloatMath.pi(precision, radix);
        boolean unitLine = z.imag().signum() == 0 && z.real().signum() > 0 && z.real().compareTo(one) < 0;
        Apcomplex i = new Apcomplex(zero, one);
        Apcomplex epi\u03bdi2 = ApcomplexMath.exp(pi.multiply(\u03bd).multiply(i).divide(two));
        Apcomplex zn = unitLine ? z : z.negate();
        Apint offset = unitLine ? zero : pi.multiply(i);
        Apcomplex \u03bd1 = ApfloatHelper.ensurePrecision(\u03bd.subtract(one), precision);
        Apcomplex logznpi2i = ApfloatHelper.ensurePrecision(ApcomplexMath.log(zn).add(offset), precision).divide(pi.multiply(two).multiply(i));
        Apcomplex oneMinusLogznpi2i = ApfloatHelper.ensurePrecision(one.subtract(logznpi2i), precision);
        Apcomplex result = ApcomplexMath.pow((Apcomplex)two.multiply(pi), \u03bd1).multiply(i).multiply(ApcomplexMath.gamma(ApfloatHelper.ensureGammaPrecision(\u03bd1.negate(), precision))).multiply(ApcomplexMath.zeta(\u03bd1.negate(), logznpi2i).divide(epi\u03bdi2).subtract(epi\u03bdi2.multiply(ApcomplexMath.zeta(\u03bd1.negate(), oneMinusLogznpi2i))));
        targetPrecision = ApfloatHelper.reducePrecision(targetPrecision, Math.max(0L, (long)Math.log((double)result.scale() * 0.3)));
        return ApfloatHelper.limitPrecision(result, targetPrecision);
    }

    public static Apcomplex logisticSigmoid(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        int radix = z.radix();
        Apint one = Apint.ONES[radix];
        if (z.isZero()) {
            Apint two = new Apint(2L, radix);
            return new Aprational(one, two);
        }
        long precision = z.precision();
        Apint minusOne = new Apint(-1L, radix);
        Apint e = z.scale() < -precision ? one : ApcomplexMath.exp(z.negate());
        return one.precision(precision).divide(one.precision(ApfloatHelper.extendPrecision(precision, e.equalDigits((Apcomplex)minusOne))).add((Apcomplex)e));
    }

    public static Apfloat ulp(Apcomplex z) {
        return ApfloatMath.max(ApfloatMath.ulp(z.real()), ApfloatMath.ulp(z.imag()));
    }

    private static Apcomplex lastIterationExtendPrecision(int iterations, int precisingIteration, Apcomplex z) {
        return iterations == 0 && precisingIteration != 0 ? ApfloatHelper.extendPrecision(z) : z;
    }

    static boolean isNonPositiveInteger(Apcomplex z) {
        return z.isInteger() && z.real().signum() <= 0;
    }
}

