/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.apfloat.Apfloat;
import org.apfloat.spi.Util;

class RootFinder {
    private RootFinder() {
    }

    public static Apfloat findRoot(Function<Apfloat, Apfloat> f, BiFunction<Apfloat, Apfloat, Apfloat> fp, Apfloat y, Apfloat initialGuess, long targetPrecision) {
        long precision;
        Apfloat x = initialGuess;
        long workingPrecision = x.precision();
        do {
            Apfloat fn = f.apply(x);
            Apfloat fpn = fp.apply(x, fn);
            Apfloat d = fn.subtract(y).divide(fpn);
            long l = precision = d.signum() == 0 ? x.precision() : x.scale() - d.scale();
            if (precision > 0L) {
                workingPrecision = Math.min(targetPrecision, Math.max(workingPrecision, Util.ifFinite(precision, 2L * Util.ifFinite(precision, 2L * precision))));
            }
            x = x.subtract(d).precision(workingPrecision);
        } while (precision < targetPrecision);
        return x.precision(targetPrecision);
    }
}

