/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apfloat.ApfloatContext;
import org.apfloat.samples.Operation;

public class BackgroundOperation<T> {
    private Future<T> future;

    public BackgroundOperation(Operation<T> operation) {
        ApfloatContext ctx = ApfloatContext.getContext();
        ExecutorService executorService = ctx.getExecutorService();
        FutureTask<Object> futureTask = new FutureTask<Object>(operation::execute);
        executorService.execute(futureTask);
        this.future = futureTask;
    }

    public boolean isFinished() {
        return this.future.isDone();
    }

    public void cancel() {
        this.future.cancel(true);
    }

    public T getResult() {
        ApfloatContext ctx = ApfloatContext.getContext();
        ctx.wait(this.future);
        try {
            return this.future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

