/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.jscience;

import javolution.text.Text;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatMath;
import org.apfloat.Apint;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.structure.Field;

public abstract class AbstractField<T extends AbstractField<T, V>, V extends Apcomplex>
extends Number<T>
implements Field<T> {
    private static final long serialVersionUID = -7725271295007354895L;
    private V value;

    protected AbstractField(V value) {
        if (value == null) {
            throw new NullPointerException("Value can't be null");
        }
        this.value = value;
    }

    public abstract T plus(T var1);

    public abstract T opposite();

    public abstract T times(T var1);

    public abstract T inverse() throws ArithmeticException;

    public abstract T copy();

    public boolean isLargerThan(T that) {
        return ApcomplexMath.norm(this.value()).compareTo(ApcomplexMath.norm(((AbstractField)((Object)that)).value())) > 0;
    }

    public V value() {
        return this.value;
    }

    public double doubleValue() {
        return this.value().doubleValue();
    }

    public long longValue() {
        return this.value().longValue();
    }

    public Text toText() {
        return Text.valueOf((Object)this.value().toString());
    }

    public int compareTo(T that) {
        int result = this.value().real().compareTo(((AbstractField)((Object)that)).value().real());
        if (result == 0) {
            result = this.value().imag().compareTo(((AbstractField)((Object)that)).value().imag());
        }
        return result;
    }

    public int hashCode() {
        return this.value().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractField) {
            AbstractField that = (AbstractField)((Object)obj);
            return this.value().equals(that.value());
        }
        return false;
    }

    static Apfloat parse(String prefix, XMLFormat.InputElement xml) throws XMLStreamException {
        String mantissa = xml.getAttribute(prefix + "mantissa", "0");
        long exponent = Long.parseLong(xml.getAttribute(prefix + "exponent", "0"));
        long precision = Long.parseLong(xml.getAttribute(prefix + "precision", String.valueOf(mantissa.length())));
        int radix = Integer.parseInt(xml.getAttribute(prefix + "radix", String.valueOf(ApfloatContext.getContext().getDefaultRadix())));
        return ApfloatMath.scale((Apfloat)new Apint(mantissa, radix).precision(precision), (long)exponent);
    }

    static void format(Apfloat value, String prefix, XMLFormat.OutputElement xml) throws XMLStreamException {
        AbstractField.format(value, prefix, xml, value.precision());
    }

    static void format(Apfloat value, String prefix, XMLFormat.OutputElement xml, Long precision) throws XMLStreamException {
        Apint mantissa = ApfloatMath.scale((Apfloat)value, (long)Math.subtractExact(value.size(), value.scale())).truncate();
        long exponent = value.signum() == 0 ? 0L : Math.subtractExact(value.scale(), value.size());
        xml.setAttribute(prefix + "mantissa", mantissa.toString());
        xml.setAttribute(prefix + "exponent", exponent);
        if (precision != null) {
            xml.setAttribute(prefix + "precision", precision.longValue());
        }
        xml.setAttribute(prefix + "radix", value.radix());
    }
}

