/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.jscience;

import java.io.Serializable;
import java.util.Objects;
import javolution.context.LocalContext;
import javolution.lang.Realtime;
import javolution.text.Text;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.apfloat.Apfloat;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.jscience.AbstractField;
import org.apfloat.jscience.ModuloApintField;
import org.jscience.mathematics.structure.GroupAdditive;

public class EllipticCurveGroup
implements GroupAdditive<EllipticCurveGroup>,
Realtime,
XMLSerializable,
Serializable {
    static final XMLFormat<EllipticCurveGroup> XML = new XMLFormat<EllipticCurveGroup>(EllipticCurveGroup.class){

        public EllipticCurveGroup newInstance(Class<EllipticCurveGroup> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new EllipticCurveGroup(AbstractField.parse("x-", xml).truncate(), AbstractField.parse("y-", xml).truncate());
        }

        public void write(EllipticCurveGroup group, XMLFormat.OutputElement xml) throws XMLStreamException {
            AbstractField.format((Apfloat)group.x.value(), "x-", xml, null);
            AbstractField.format((Apfloat)group.y.value(), "y-", xml, null);
        }

        public void read(XMLFormat.InputElement xml, EllipticCurveGroup group) throws XMLStreamException {
        }
    };
    public static final EllipticCurveGroup O = new EllipticCurveGroup((ModuloApintField)null, (ModuloApintField)null);
    private static final long serialVersionUID = 4239380063596030297L;
    private final ModuloApintField x;
    private final ModuloApintField y;
    private static final LocalContext.Reference<ModuloApintField> weierstrassA = new LocalContext.Reference();
    private static final LocalContext.Reference<ModuloApintField> weierstrassB = new LocalContext.Reference();
    private static final LocalContext.Reference<ModuloApintField> montgomeryA = new LocalContext.Reference();
    private static final LocalContext.Reference<ModuloApintField> montgomeryB = new LocalContext.Reference();

    public EllipticCurveGroup(Apint x, Apint y) {
        this(new ModuloApintField(x), new ModuloApintField(y));
    }

    private EllipticCurveGroup(ModuloApintField x, ModuloApintField y) {
        this.x = x;
        this.y = y;
    }

    public static EllipticCurveGroup fromMontgomeryPoint(Apint x, Apint y) {
        return EllipticCurveGroup.fromMontgomeryPoint(new ModuloApintField(x), new ModuloApintField(y));
    }

    private static EllipticCurveGroup fromMontgomeryPoint(ModuloApintField x, ModuloApintField y) {
        ModuloApintField A = (ModuloApintField)((Object)montgomeryA.get());
        ModuloApintField B = (ModuloApintField)((Object)montgomeryB.get());
        if (A == null || B == null) {
            throw new IllegalStateException("Curve parameters have not been set");
        }
        int radix = ((Apint)x.value()).radix();
        ModuloApintField inverseB = B.inverse();
        ModuloApintField inverseThree = new ModuloApintField(new Apint(3L, radix)).inverse();
        return new EllipticCurveGroup(x.times(inverseB).plus(A.times(inverseB).times(inverseThree)), y.times(inverseB));
    }

    public static EllipticCurveGroup fromEdwardsPoint(Apint x, Apint y) {
        return EllipticCurveGroup.fromEdwardsPoint(new ModuloApintField(x), new ModuloApintField(y));
    }

    private static EllipticCurveGroup fromEdwardsPoint(ModuloApintField x, ModuloApintField y) {
        int radix = ((Apint)x.value()).radix();
        ModuloApintField one = new ModuloApintField(new Apint(1L, radix));
        ModuloApintField y1 = one.plus(y).times(((ModuloApintField)one.minus(y)).inverse());
        return EllipticCurveGroup.fromMontgomeryPoint(y1, y1.times(x.inverse()));
    }

    public static void setWeierstrassParameters(Apint a, Apint b, Apint p) {
        ModuloApintField.setModulus(p);
        int radix = a.radix();
        ModuloApintField \u03b1 = new ModuloApintField(a);
        ModuloApintField \u03b2 = new ModuloApintField(b);
        ModuloApintField four = new ModuloApintField(new Apint(4L, radix));
        ModuloApintField twentyseven = new ModuloApintField(new Apint(3L, radix));
        if (((Apint)four.times(\u03b1).times(\u03b1).times(\u03b1).plus(twentyseven.times(\u03b2).times(\u03b2)).value()).signum() == 0) {
            throw new IllegalArgumentException("Curve is not valid");
        }
        weierstrassA.set((Object)\u03b1);
        weierstrassB.set((Object)\u03b2);
        montgomeryA.set(null);
        montgomeryB.set(null);
    }

    public static void setMontgomeryParameters(Apint b, Apint a, Apint p) {
        int radix = p.radix();
        ModuloApintField.setModulus(p);
        ModuloApintField A = new ModuloApintField(a);
        ModuloApintField B = new ModuloApintField(b);
        ModuloApintField two = new ModuloApintField(new Apint(2L, radix));
        ModuloApintField three = new ModuloApintField(new Apint(3L, radix));
        ModuloApintField nine = new ModuloApintField(new Apint(9L, radix));
        ModuloApintField twentyseven = new ModuloApintField(new Apint(27L, radix));
        EllipticCurveGroup.setWeierstrassParameters((Apint)((ModuloApintField)three.minus(A.times(A))).times(three.times(B).times(B).inverse()).value(), (Apint)((ModuloApintField)two.times(A).times(A).minus(nine)).times(A).times(twentyseven.times(B).times(B).times(B).inverse()).value(), p);
        montgomeryA.set((Object)A);
        montgomeryB.set((Object)B);
    }

    public static void setEdwardsParameters(Apint a, Apint d, Apint p) {
        int radix = p.radix();
        ModuloApintField.setModulus(p);
        ModuloApintField x = new ModuloApintField(a.subtract(d)).inverse();
        ModuloApintField ad = new ModuloApintField(a.add(d));
        ModuloApintField two = new ModuloApintField(new Apint(2L, radix));
        ModuloApintField four = new ModuloApintField(new Apint(4L, radix));
        EllipticCurveGroup.setMontgomeryParameters((Apint)four.times(x).value(), (Apint)two.times(ad).times(x).value(), p);
    }

    public static Apint getA() {
        return (Apint)((ModuloApintField)((Object)weierstrassA.get())).value();
    }

    public static Apint getB() {
        return (Apint)((ModuloApintField)((Object)weierstrassB.get())).value();
    }

    public static Apint getJInvariant() {
        ModuloApintField a = (ModuloApintField)((Object)weierstrassA.get());
        ModuloApintField b = (ModuloApintField)((Object)weierstrassB.get());
        int radix = ((Apint)a.value()).radix();
        ModuloApintField foura3 = new ModuloApintField(new Apint(4L, radix)).times(a).times(a).times(a);
        ModuloApintField twentyseven = new ModuloApintField(new Apint(27L, radix));
        ModuloApintField twelve3 = new ModuloApintField(new Apint(1728L, radix));
        return (Apint)twelve3.times(foura3).times(foura3.plus(twentyseven.times(b).times(b)).inverse()).value();
    }

    public Apint getX() {
        return (Apint)this.x.value();
    }

    public Apint getY() {
        return (Apint)this.y.value();
    }

    public EllipticCurveGroup plus(EllipticCurveGroup that) {
        ModuloApintField y;
        ModuloApintField x;
        if (this.equals(O)) {
            return that;
        }
        if (that.equals(O)) {
            return this;
        }
        ModuloApintField a = (ModuloApintField)((Object)weierstrassA.get());
        ModuloApintField b = (ModuloApintField)((Object)weierstrassB.get());
        if (a == null || b == null) {
            throw new IllegalStateException("Curve parameters have not been set");
        }
        if (!this.x.equals((Object)that.x)) {
            ModuloApintField \u03bb = ((ModuloApintField)that.y.minus(this.y)).times(((ModuloApintField)that.x.minus(this.x)).inverse());
            x = (ModuloApintField)((ModuloApintField)\u03bb.times(\u03bb).minus(this.x)).minus(that.x);
            y = (ModuloApintField)\u03bb.times((ModuloApintField)this.x.minus(x)).minus(this.y);
        } else if (this.y.equals((Object)that.y)) {
            int radix = ((Apint)this.y.value()).radix();
            ModuloApintField two = new ModuloApintField(new Apint(2L, radix));
            ModuloApintField three = new ModuloApintField(new Apint(3L, radix));
            ModuloApintField \u03bb = three.times(this.x).times(this.x).plus(a).times(two.times(this.y).inverse());
            x = (ModuloApintField)\u03bb.times(\u03bb).minus(two.times(this.x));
            y = (ModuloApintField)\u03bb.times((ModuloApintField)this.x.minus(x)).minus(this.y);
        } else {
            assert (this.x.equals((Object)that.x) && this.y.equals((Object)that.y.opposite()));
            return O;
        }
        assert (y.times(y).equals((Object)x.times(x).plus(a).times(x).plus(b)));
        return new EllipticCurveGroup(x, y);
    }

    public EllipticCurveGroup times(Apint that) {
        if (this.equals(O)) {
            return this;
        }
        if (that.signum() < 0) {
            return this.opposite().times(that.negate());
        }
        Apint two = new Apint(2L, that.radix());
        EllipticCurveGroup a = this;
        EllipticCurveGroup result = O;
        while (that.signum() != 0) {
            Apint[] qr = ApintMath.div((Apint)that, (Apint)two);
            if (qr[1].signum() != 0) {
                result = result.plus(a);
            }
            if (qr[0].signum() != 0) {
                a = a.plus(a);
            }
            that = qr[0];
        }
        return result;
    }

    public EllipticCurveGroup opposite() {
        if (this.equals(O)) {
            return this;
        }
        return new EllipticCurveGroup(this.x, this.y.opposite());
    }

    public EllipticCurveGroup copy() {
        if (this.equals(O)) {
            return new EllipticCurveGroup((ModuloApintField)null, (ModuloApintField)null);
        }
        return new EllipticCurveGroup((Apint)this.x.value(), (Apint)this.y.value());
    }

    public Text toText() {
        if (this.equals(O)) {
            return Text.valueOf((Object)"(\u221e, \u221e)");
        }
        return Text.valueOf((Object)("(" + (Object)((Object)this.x) + ", " + (Object)((Object)this.y) + ')'));
    }

    public String toString() {
        return this.toText().toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object)this.x) + 3 * Objects.hashCode((Object)this.y);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EllipticCurveGroup) {
            EllipticCurveGroup that = (EllipticCurveGroup)obj;
            return Objects.equals((Object)this.x, (Object)that.x) && Objects.equals((Object)this.y, (Object)that.y);
        }
        return false;
    }
}

