/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import com.aparapi.Range;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.aparapi.IntKernel;
import org.apfloat.aparapi.RangeHelper;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.MatrixStrategy;

public class IntAparapiMatrixStrategy
implements MatrixStrategy {
    public void transpose(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        if (n1 != (n1 & -n1) || n2 != (n2 & -n2) || n1 <= 0 || n2 <= 0) {
            throw new ApfloatInternalException("Matrix size must be a power of two, not " + n1 + " x " + n2);
        }
        if (n1 == n2) {
            this.transposeSquare(arrayAccess, n1, n1);
        } else if (n2 == 2 * n1) {
            this.transposeSquare(arrayAccess, n1, n2);
            this.transposeSquare(arrayAccess.subsequence(n1, arrayAccess.getLength() - n1), n1, n2);
            this.permuteToHalfWidth(arrayAccess, n1, n2);
        } else if (n1 == 2 * n2) {
            this.permuteToDoubleWidth(arrayAccess, n1, n2);
            this.transposeSquare(arrayAccess, n2, n1);
            this.transposeSquare(arrayAccess.subsequence(n2, arrayAccess.getLength() - n2), n2, n1);
        } else {
            throw new ApfloatInternalException("Must be n1 = n2, n1 = 2*n2 or n2 = 2*n1; matrix is " + n1 + " x " + n2);
        }
    }

    public void transposeSquare(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        IntKernel kernel = IntKernel.getInstance();
        kernel.setOp(3);
        kernel.setArrayAccess(arrayAccess);
        kernel.setN2(n2);
        Range range = RangeHelper.create2D(n1, n1);
        kernel.execute(range);
    }

    public void permuteToHalfWidth(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        if (n1 != (n1 & -n1) || n2 != (n2 & -n2) || n1 <= 0 || n2 <= 0) {
            throw new ApfloatInternalException("Matrix size must be a power of two, not " + n1 + " x " + n2);
        }
        if (n1 < 2) {
            return;
        }
        int twicen1 = 2 * n1;
        boolean[] isRowDone = new boolean[twicen1];
        int[] index = new int[twicen1 * 2];
        int j = 1;
        int p = 0;
        do {
            int m = j;
            index[p++] = m;
            isRowDone[m] = true;
            int n = m = m < n1 ? 2 * m : 2 * (m - n1) + 1;
            while (m != j) {
                isRowDone[m] = true;
                index[p++] = m;
                m = m < n1 ? 2 * m : 2 * (m - n1) + 1;
            }
            index[p++] = 0;
            while (isRowDone[j]) {
                ++j;
            }
        } while (j < twicen1 - 1);
        IntKernel kernel = IntKernel.getInstance();
        kernel.setOp(4);
        kernel.setArrayAccess(arrayAccess);
        kernel.setN2(n2 / 2);
        kernel.setIndex(index);
        kernel.setIndexCount(p);
        kernel.put(index);
        Range range = RangeHelper.create(n2 / 2);
        kernel.execute(range);
    }

    public void permuteToDoubleWidth(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        if (n1 != (n1 & -n1) || n2 != (n2 & -n2) || n1 <= 0 || n2 <= 0) {
            throw new ApfloatInternalException("Matrix size must be a power of two, not " + n1 + " x " + n2);
        }
        if (n1 < 2) {
            throw new ApfloatInternalException("Matrix height must be at least 2.");
        }
        if (n1 < 4) {
            return;
        }
        int halfn1 = n1 / 2;
        boolean[] isRowDone = new boolean[n1];
        int[] index = new int[n1 * 2];
        int j = 1;
        int p = 0;
        do {
            int m = j;
            index[p++] = m;
            isRowDone[m] = true;
            int n = m = (m & 1) != 0 ? m / 2 + halfn1 : m / 2;
            while (m != j) {
                isRowDone[m] = true;
                index[p++] = m;
                m = (m & 1) != 0 ? m / 2 + halfn1 : m / 2;
            }
            index[p++] = 0;
            while (isRowDone[j]) {
                ++j;
            }
        } while (j < n1 - 1);
        IntKernel kernel = IntKernel.getInstance();
        kernel.setOp(4);
        kernel.setArrayAccess(arrayAccess);
        kernel.setN2(n2);
        kernel.setIndex(index);
        kernel.setIndexCount(p);
        kernel.put(index);
        Range range = RangeHelper.create(n2);
        kernel.execute(range);
    }
}

