/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import org.apfloat.ApfloatContext;
import org.apfloat.aparapi.IntAparapiColumnSixStepFNTStrategy;
import org.apfloat.aparapi.IntAparapiColumnTwoPassFNTStrategy;
import org.apfloat.aparapi.IntAparapiFactor3NTTStrategy;
import org.apfloat.aparapi.IntAparapiNTTStrategy;
import org.apfloat.aparapi.IntAparapiSixStepFNTStrategy;
import org.apfloat.aparapi.IntAparapiTwoPassFNTStrategy;
import org.apfloat.internal.IntNTTBuilder;
import org.apfloat.spi.BuilderFactory;
import org.apfloat.spi.NTTStrategy;

public class IntAparapiNTTBuilder
extends IntNTTBuilder {
    private static final int MIN_GPU_LENGTH = 0x100000;
    private boolean rowOrientation;

    public IntAparapiNTTBuilder(boolean rowOrientation) {
        this.rowOrientation = rowOrientation;
    }

    protected NTTStrategy createSixStepFNTStrategy(long size) {
        long length = size;
        if (length < 0x100000L) {
            return super.createSixStepFNTStrategy(size);
        }
        return this.rowOrientation ? new IntAparapiSixStepFNTStrategy() : new IntAparapiColumnSixStepFNTStrategy();
    }

    protected NTTStrategy createTwoPassFNTStrategy(long size) {
        long length = size;
        if (length < 0x100000L) {
            return super.createTwoPassFNTStrategy(size);
        }
        return this.rowOrientation ? new IntAparapiTwoPassFNTStrategy() : new IntAparapiColumnTwoPassFNTStrategy();
    }

    protected NTTStrategy createFactor3NTTStrategy(long size, NTTStrategy nttStrategy) {
        if (nttStrategy instanceof IntAparapiNTTStrategy) {
            ApfloatContext ctx = ApfloatContext.getContext();
            BuilderFactory builderFactory = ctx.getBuilderFactory();
            long maxMemoryBlockSize = ctx.getMaxMemoryBlockSize() / (long)builderFactory.getElementSize();
            if (size <= maxMemoryBlockSize && size <= Integer.MAX_VALUE) {
                return new IntAparapiFactor3NTTStrategy(nttStrategy);
            }
        }
        return super.createFactor3NTTStrategy(size, nttStrategy);
    }
}

